/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.admin.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.admin.persistence.IdGenerator;

public class IncrementalGenerator
implements IdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generate(DataSource dataSource, String tableName, String columnName) {
        Integer newId = null;
        try {
            Connection conn = dataSource.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(String.format("SELECT max(%s) FROM %s", columnName, tableName));
                ResultSet result = stmt.executeQuery();
                newId = result.next() ? result.getInt(1) + 1 : 1;
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException ex) {
            logger.error(columnName, (Throwable)ex);
        }
        return newId.toString();
    }
}

