/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.browsercheck;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.browsercheck.BrowserValidator;

public class BrowserFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(BrowserFilter.class);
    private BrowserValidator browserValidator = new BrowserValidator();
    private List<String> ignoredUrlList;

    public void init(FilterConfig fc) throws ServletException {
        String ignoredUrls = fc.getInitParameter("ignoredUrls");
        if (StringUtils.isNotEmpty((CharSequence)ignoredUrls)) {
            this.ignoredUrlList = Arrays.asList(ignoredUrls.split(","));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String userAgent;
        String url = ((HttpServletRequest)request).getRequestURI();
        boolean isIgnore = url.endsWith("checkbrowser.html");
        if (this.ignoredUrlList != null) {
            Iterator<String> iterator = this.ignoredUrlList.iterator();
            while (!isIgnore && iterator.hasNext()) {
                String ignoredUrl = iterator.next();
                isIgnore = url.startsWith(ignoredUrl);
            }
        }
        if (!isIgnore && !this.browserValidator.isValidBrowser(userAgent = ((HttpServletRequest)request).getHeader("User-Agent"))) {
            logger.info("\u0417\u0430\u043f\u0440\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0434\u043b\u044f \u0431\u0440\u0430\u0443\u0437\u0435\u0440\u0430 [{}]", (Object)userAgent);
            logger.info("\u0417\u0430\u0431\u0430\u043d\u0435\u043d\u043d\u044b\u0439 \u0443\u0440\u043b: {}", (Object)url);
            ((HttpServletResponse)response).sendRedirect("/checkbrowser.html");
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

