/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.controller;

import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import ru.tssoft.kege.dao.FileStorageDao;
import ru.tssoft.kege.dao.MimeTypeHelper;
import ru.tssoft.kege.dao.SessionFileStorage;
import ru.tssoft.kege.dao.SessionFileStorageDao;
import ru.tssoft.kege.model.FileStorage;

@Controller
public class FileController {
    private static final Logger logger = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private SessionFileStorageDao sessionFileStorageDao;
    @Autowired
    private FileStorageDao fileStorageDao;

    @RequestMapping(value={"/file/{fileName}.{fileExt}"}, method={RequestMethod.GET})
    public void file(@PathVariable String fileName, @PathVariable String fileExt, HttpServletResponse response) {
        String nameWithExt = String.format("%1$s.%2$s", fileName, fileExt);
        try {
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            if (attr == null) {
                logger.warn("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b [{}] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u0435\u0441\u0441\u0438\u0438 (attr is null)", (Object)nameWithExt);
                return;
            }
            HttpSession httpSession = attr.getRequest().getSession(false);
            if (httpSession == null) {
                logger.warn("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b [{}] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u0435\u0441\u0441\u0438\u0438 (httpSession is null)", (Object)nameWithExt);
                return;
            }
            byte[] fileBytes = new SessionFileStorage(httpSession).getFileFromSession(nameWithExt);
            response.setContentType(MimeTypeHelper.GetMimeType(nameWithExt));
            response.setHeader("Content-Disposition", "attachment; filename=\"" + nameWithExt + "\"");
            response.setContentLength(fileBytes.length);
            FileCopyUtils.copy((byte[])fileBytes, (OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            logger.error("\u041f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0444\u0430\u0439\u043b\u0430 [{}] \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Object)nameWithExt);
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getonce/{fileId}"}, method={RequestMethod.GET})
    public void getOnce(@PathVariable String fileId, HttpServletResponse response) {
        try {
            FileStorage fileStorage = this.fileStorageDao.getFileStorage(fileId);
            response.setContentType(MimeTypeHelper.GetMimeType(fileStorage.getFileName()));
            response.setHeader("Content-Transfer-Encoding", "binary");
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", fileStorage.getFileName()));
            InputStream fileStream = fileStorage.getInputStream();
            response.setContentLength(fileStream.available());
            FileCopyUtils.copy((InputStream)fileStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.fileStorageDao.deleteFile(fileId);
        }
    }

    @RequestMapping(value={"/get/{fileName}.{fileExt}"}, method={RequestMethod.GET})
    public void get(@PathVariable String fileName, @PathVariable String fileExt, HttpServletResponse response) {
        String nameWithExt = String.format("%1$s.%2$s", fileName, fileExt);
        try {
            InputStream inputStream = this.sessionFileStorageDao.getFileStorage("pdfsession", nameWithExt).getInputStream();
            response.setContentType(MimeTypeHelper.GetMimeType(nameWithExt));
            response.setHeader("Content-Disposition", "attachment; filename=\"" + nameWithExt + "\"");
            int bytesCount = FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.setContentLength(bytesCount);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

