/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.util.HashMap;
import java.util.Map;

public class MimeTypeHelper {
    public static final String MIME_PDF = "application/pdf";
    public static final String MIME_HTML = "text/html";
    private static final Map<String, String> mimes = new HashMap<String, String>();

    public static String GetMimeType(String fileExt) {
        if (fileExt == null || "".equals(fileExt)) {
            return null;
        }
        Boolean startWithDot = fileExt.startsWith(".");
        if (startWithDot.booleanValue() && fileExt.length() == 1) {
            return null;
        }
        String ext = startWithDot != false ? fileExt.trim().substring(1, fileExt.length()) : fileExt.trim();
        return mimes.get(ext);
    }

    static {
        mimes.put("bmp", "image/bmp");
        mimes.put("gif", "image/gif");
        mimes.put("jpeg", "image/jpeg");
        mimes.put("jpg", "image/jpeg");
        mimes.put("png", "image/png");
        mimes.put("tif", "image/tiff");
        mimes.put("tiff", "image/tiff");
        mimes.put("doc", "application/msword");
        mimes.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimes.put("pdf", MIME_PDF);
        mimes.put("ppt", "application/vnd.ms-powerpoint");
        mimes.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimes.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimes.put("xls", "application/vnd.ms-excel");
        mimes.put("csv", "text/csv");
        mimes.put("xml", "text/xml");
        mimes.put("txt", "text/plain");
        mimes.put("zip", "application/zip");
        mimes.put("ogg", "application/ogg");
        mimes.put("mp3", "audio/mpeg");
        mimes.put("wma", "audio/x-ms-wma");
        mimes.put("wav", "audio/x-wav");
        mimes.put("wmv", "audio/x-ms-wmv");
        mimes.put("swf", "application/x-shockwave-flash");
        mimes.put("avi", "video/avi");
        mimes.put("mp4", "video/mp4");
        mimes.put("mpeg", "video/mpeg");
        mimes.put("mpg", "video/mpeg");
        mimes.put("qt", "video/quicktime");
    }
}

