/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.dao.DaoRowHandler;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.dao.EnumJoinHelper;
import ru.tssoft.kege.model.CryptedString;
import ru.tssoft.kege.model.ParticipantCorrectionStatus;
import ru.tssoft.kege.model.ParticipantExamStatus;
import ru.tssoft.kege.model.ParticipantFio;

@Component
public class ParticipantSharedDao
extends AbstractDao {
    private static final Logger logger = LoggerFactory.getLogger(ParticipantSharedDao.class);

    public ParticipantExamStatus getParticipantExamStatus(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "SELECT      ps.exam_status FROM      participant_seating ps WHERE      ps.participant_id = ? ";
        ArrayList statuses = new ArrayList();
        jdbcTemplate.query(queryText, new Object[]{participantId.toString()}, new DaoRowHandler<ParticipantExamStatus>(statuses, new EntityMapper<ParticipantExamStatus>(){

            @Override
            public ParticipantExamStatus toEntity(ResultSet resultSet) throws SQLException {
                return ParticipantExamStatus.valueOf(this.getString(resultSet, "exam_status"));
            }
        }));
        return statuses.size() == 1 ? (ParticipantExamStatus)((Object)statuses.get(0)) : null;
    }

    public ParticipantExamStatus getParticipantExamStatusExtra(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "SELECT      ps.exam_status_extra FROM      participant_seating ps WHERE      ps.participant_id = ? ";
        ArrayList statuses = new ArrayList();
        jdbcTemplate.query(queryText, new Object[]{participantId.toString()}, new DaoRowHandler<ParticipantExamStatus>(statuses, new EntityMapper<ParticipantExamStatus>(){

            @Override
            public ParticipantExamStatus toEntity(ResultSet resultSet) throws SQLException {
                String statusExtra = this.getString(resultSet, "exam_status_extra");
                return StringUtils.isEmpty((CharSequence)statusExtra) ? null : ParticipantExamStatus.valueOf(statusExtra);
            }
        }));
        return statuses.size() == 1 ? (ParticipantExamStatus)((Object)statuses.get(0)) : null;
    }

    public void assignExamStartTime(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int isLate = jdbcTemplate.queryForInt("select is_late from participant_seating where participant_id = ?", new Object[]{participantId.toString()});
        String startTimeStmt = isLate == 0 ? "current_timestamp" : "(select coalesce(max(exam_start_time), current_timestamp) from participant_seating where is_late = 0)";
        jdbcTemplate.update("update participant_seating set    exam_real_start_time = current_timestamp,    exam_start_time = " + startTimeStmt + " where participant_id = ?", new Object[]{participantId.toString()});
    }

    public void assignExamStatus(UUID participantId, ParticipantExamStatus examStatus) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update participant_seating set    exam_status = ?  where participant_id = ?", new Object[]{examStatus.name(), participantId.toString()});
        if (ParticipantExamStatus.PrintBlank.equals((Object)examStatus)) {
            this.assignPartCOnly(participantId, false);
        }
    }

    public void assignExamStatusExtra(UUID participantId, ParticipantExamStatus examStatus) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update participant_seating set    exam_status_extra = ?  where participant_id = ?", new Object[]{examStatus.name(), participantId.toString()});
    }

    public void updateCorrectionStatus(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update participant_seating set correction_status = ? where participant_id = ? and changed = 1 ", new Object[]{ParticipantCorrectionStatus.Accepted.getValue(), participantId.toString()});
        jdbcTemplate.update("update participant_seating set correction_status = ? where participant_id = ? and changed = 0 ", new Object[]{ParticipantCorrectionStatus.None.getValue(), participantId.toString()});
    }

    public void setIsLate(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update participant_seating set      is_late = 1,      exam_start_time = (select coalesce(max(exam_start_time), current_timestamp) from participant_seating where is_late = 0 and participant_id <> ?) where participant_id = ?", new Object[]{participantId.toString(), participantId.toString()});
        this.assignExamStatus(participantId, ParticipantExamStatus.NotEntered);
    }

    public int getParticipantStatusesCount(ParticipantExamStatus status) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "select      count(1) from      participant_seating where      exam_status = ?      and auditorium_id = (select auditorium_id from auditorium where active = 1 fetch first 1 row only)";
        return jdbcTemplate.queryForInt(queryText, new Object[]{status.toString()});
    }

    public Integer getTimeLeft(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int count = jdbcTemplate.queryForInt("select    COALESCE({fn TIMESTAMPDIFF( SQL_TSI_MINUTE, ps.exam_start_time, current_timestamp) }, -1) as ddd from    participant_seating ps where    ps.participant_id = ? ", new Object[]{participantId.toString()});
        return count >= 0 ? 240 - count : Integer.MAX_VALUE;
    }

    public String getTimeLeftText(UUID participantId, ParticipantExamStatus participantExamStatus) {
        int minutesLeft = this.getTimeLeft(participantId);
        return this.formatTimeLeft(minutesLeft, participantExamStatus);
    }

    public String formatTimeLeft(int minutesLeft, ParticipantExamStatus participantExamStatus) {
        switch (participantExamStatus) {
            case NotEntered: 
            case PrintKim: 
            case NotStarted: 
            case Absence: {
                return "--:--";
            }
            case PrintBlank: 
            case CheckBlank: 
            case Started: {
                if (minutesLeft < 0 || minutesLeft == Integer.MAX_VALUE) {
                    return "00:00";
                }
                long hours = TimeUnit.MINUTES.toHours(minutesLeft);
                return String.format("%d:%02d", hours, TimeUnit.MINUTES.toMinutes(minutesLeft) - TimeUnit.HOURS.toMinutes(hours));
            }
            case NotCompleteByValidReason: 
            case Banned: 
            case BlankAccepted: {
                return "00:00";
            }
        }
        return "--:--";
    }

    public String getParticipantFio(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList fios = new ArrayList();
        String queryText = "select    surname,    name,    second_name from    participant_seating where    participant_id = ? ";
        jdbcTemplate.query(queryText, new Object[]{participantId.toString()}, new DaoRowHandler<String>(fios, new EntityMapper<String>(){

            @Override
            public String toEntity(ResultSet rs) throws SQLException {
                try {
                    return ParticipantFio.decrypt(rs.getBytes("surname"), rs.getBytes("name"), rs.getBytes("second_name"));
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    return "";
                }
            }
        }));
        return fios.size() > 0 ? (String)fios.get(0) : "";
    }

    public String getRandomParticipantSurname() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList surnames = new ArrayList();
        String queryText = "select    surname from    participant_seating fetch first 1 row only";
        jdbcTemplate.query(queryText, new DaoRowHandler<String>(surnames, new EntityMapper<String>(){

            @Override
            public String toEntity(ResultSet resultSet) throws SQLException {
                try {
                    return CryptedString.decrypt(this.getBlobBytes(resultSet, "surname"));
                }
                catch (Exception ex) {
                    throw new SQLException(ex);
                }
            }
        }));
        return surnames.size() > 0 ? (String)surnames.get(0) : "";
    }

    public String getAssignedVariant(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "SELECT variant_code FROM participant_seating ps WHERE ps.participant_id = ? ";
        ArrayList variants = new ArrayList();
        jdbcTemplate.query(queryText, new Object[]{participantId.toString()}, new DaoRowHandler<String>(variants, new EntityMapper<String>(){

            @Override
            public String toEntity(ResultSet resultSet) throws SQLException {
                return this.getString(resultSet, "variant_code");
            }
        }));
        return variants.size() == 1 ? (String)variants.get(0) : null;
    }

    public void assignVariant(UUID participantId, String variantCode) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "update    participant_seating set    variant_code = ? where    participant_id = ? ";
        jdbcTemplate.update(queryText, new Object[]{variantCode, participantId.toString()});
    }

    public List<String> getVariantCodesForAllocation() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList<String> variantCodes = new ArrayList<String>();
        String queryText = "select q1.variant_code from (     select v.variant_code, count(ps.participant_id) count     from variant v         left join participant_seating ps on ps.variant_code = v.variant_code     group by v.variant_code ) q1 join (     select min(qq.count) mincount     from     (         select v.variant_code, count(ps.participant_id) count         from variant v             left join participant_seating ps on ps.variant_code = v.variant_code         group by v.variant_code     ) qq ) q2 on q1.count = q2.mincount ";
        jdbcTemplate.query(queryText, new DaoRowHandler<String>(variantCodes, new EntityMapper<String>(){

            @Override
            public String toEntity(ResultSet resultSet) throws SQLException {
                return this.getString(resultSet, "variant_code");
            }
        }));
        return variantCodes;
    }

    public boolean isKimIdAssigned(UUID participantId) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        return 0 < jt.queryForInt("SELECT COUNT(1) FROM participant_seating ps WHERE    ps.participant_id = ? AND kim_id IS NOT NULL ", new Object[]{participantId.toString()});
    }

    public String getAssignedKimId(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "SELECT      kim_id FROM      participant_seating ps WHERE      ps.participant_id = ? ";
        ArrayList kimIds = new ArrayList();
        jdbcTemplate.query(queryText, new Object[]{participantId.toString()}, new DaoRowHandler<String>(kimIds, new EntityMapper<String>(){

            @Override
            public String toEntity(ResultSet resultSet) throws SQLException {
                return this.getString(resultSet, "kim_id");
            }
        }));
        return kimIds.size() == 1 ? (String)kimIds.get(0) : null;
    }

    public void setParticipantKimId(UUID participantId, String kimId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String queryText = "update    participant_seating set    kim_id = ? where    participant_id = ? ";
        jdbcTemplate.update(queryText, new Object[]{kimId, participantId.toString()});
    }

    public void assignPartCOnly(UUID participantId, boolean value) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update participant_seating set    part_c_only = ?  where participant_id = ?", new Object[]{value ? 1 : 0, participantId.toString()});
    }

    public int getUncompletedExams() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        return jdbcTemplate.queryForInt(String.format("select     count(*) from     PARTICIPANT_SEATING PS     join PLACE P on PS.PLACE_ID = P.PLACE_ID     join AUDITORIUM A on P.AUDITORIUM_ID = A.AUDITORIUM_ID          and A.ACTIVE = 1where     PS.EXAM_STATUS in (%s)", EnumJoinHelper.quoteAndJoin(new ParticipantExamStatus[]{ParticipantExamStatus.NotEntered, ParticipantExamStatus.PrintKim, ParticipantExamStatus.NotStarted, ParticipantExamStatus.Started, ParticipantExamStatus.PrintBlank, ParticipantExamStatus.CheckBlank})));
    }
}

