/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.dao.DaoRowHandler;
import ru.tssoft.kege.dao.TaskMarkupMapper;
import ru.tssoft.kege.model.TaskMarkup;

@Component
public class TaskMarkupDao
extends AbstractDao {
    protected String imgBaseUrl = "/file/file/";

    public String getImgBaseUrl() {
        return this.imgBaseUrl;
    }

    public void setImgBaseUrl(String imgBaseUrl) {
        this.imgBaseUrl = imgBaseUrl;
    }

    public List<TaskMarkup> getTaskMarkups(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList<TaskMarkup> taskMarkups = new ArrayList<TaskMarkup>();
        jdbcTemplate.query("select    t.id ,    t.part,    t.label,   t.position,    t.xml_text,    a2.answer_text,    a2.answer_index,    a2.answer_lang,    a2.answer_encoding_text,    a2.answer_checksum_text from    task t    left join    (    select       a1.id,       a1.task_id,       a1.answer_text,       a1.answer_index,      a1.answer_lang,       a1.answer_encoding_text,       a1.answer_checksum_text    from       answer a1    where a1.is_final = 1       and a1.participant_seating_id = ?    ) a2 on t.id = a2.task_id where    t.variant_code = (select ps.variant_code from participant_seating ps where ps.participant_id = ?) order by   t.part, t.position ", new Object[]{participantId.toString(), participantId.toString()}, new DaoRowHandler<TaskMarkup>(taskMarkups, this.getTaskMarkupMapper()));
        return taskMarkups;
    }

    protected TaskMarkupMapper getTaskMarkupMapper() {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpSession session = attr.getRequest().getSession(false);
        TaskMarkupMapper taskMarkupMapper = new TaskMarkupMapper(session);
        taskMarkupMapper.setImgBaseUrl(this.imgBaseUrl);
        return taskMarkupMapper;
    }
}

