/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.dao.DaoRowHandler;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.dao.TaskMapper;
import ru.tssoft.kege.model.Task;
import ru.tssoft.kege.model.TaskMarkup;
import ru.tssoft.kege.model.ValidatableTaskMarkup;
import ru.tssoft.kege.model.ValidatableTaskMarkupMapper;
import ru.tssoft.kege.security.InternalDecryptCipher;

@Component
public class TaskSharedDao
extends AbstractDao {
    public UUID saveAnswer(UUID participantId, UUID taskId, String answer, String description, Short lang, String encoding, byte[] fileBytes, String checksum) throws SQLException {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        if (this.participantHasTask(participantId, taskId).booleanValue()) {
            ValidatableTaskMarkup task = this.getTaskMarkup(participantId, taskId);
            String answer_text = null;
            Short answer_index = null;
            Short answer_lang = null;
            String answer_encoding_text = null;
            byte[] answer_original_text = null;
            String answer_checksum_text = null;
            if (answer != null) {
                answer_text = task.getPart().toUpperCase().equals("A") || task.getPart().toUpperCase().equals("\u0410") ? description.toString() : answer.toString();
                Short s = answer_index = task.getPart().toUpperCase().equals("A") || task.getPart().toUpperCase().equals("\u0410") ? Short.valueOf(Short.parseShort(answer)) : null;
                if (task.getPart().toUpperCase().equals("C") || task.getPart().toUpperCase().equals("\u0421")) {
                    answer_lang = lang;
                    answer_encoding_text = encoding;
                    answer_original_text = fileBytes;
                    answer_checksum_text = checksum;
                } else {
                    answer_lang = null;
                    answer_encoding_text = null;
                    answer_original_text = null;
                    answer_checksum_text = null;
                }
            }
            jdbcTemplate.update("update answer set is_final = 0 where task_id = ? and participant_seating_id = ?", new Object[]{taskId.toString(), participantId.toString()});
            UUID answerId = UUID.randomUUID();
            jdbcTemplate.update("insert into    answer (id, task_id, participant_seating_id, answer_text,            answer_index, answer_lang,            answer_encoding_text, answer_checksum_text,            create_date, is_final) values    (?, ?, ?, ?, ?, ?, ?, ?, current_timestamp, 1) ", new Object[]{answerId.toString(), taskId.toString(), participantId.toString(), answer_text, answer_index, answer_lang, answer_encoding_text, answer_checksum_text});
            return answerId;
        }
        return null;
    }

    public ValidatableTaskMarkup getTaskMarkup(UUID participantId, UUID taskId) {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpSession session = attr.getRequest().getSession(false);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList taskMarkups = new ArrayList();
        jdbcTemplate.query("select      t.id,      t.part,      t.label,      t.xml_text,      (select a.answer_text from answer a where a.task_id = t.id and a.is_final = 1          and ps.PARTICIPANT_ID = a.PARTICIPANT_SEATING_ID) as answer_text,      (select a.answer_index from answer a          where a.task_id = t.id and a.is_final = 1 and ps.PARTICIPANT_ID = a.PARTICIPANT_SEATING_ID) as answer_index,     (select a.answer_lang from answer a where a.task_id = t.id and a.is_final = 1 and ps.PARTICIPANT_ID = a.PARTICIPANT_SEATING_ID) as answer_lang,     (select a.answer_encoding_text from answer a where a.task_id = t.id and a.is_final = 1 and ps.PARTICIPANT_ID = a.PARTICIPANT_SEATING_ID) as answer_encoding_text,      (select a.answer_checksum_text from answer a where a.task_id = t.id and a.is_final = 1 and ps.PARTICIPANT_ID = a.PARTICIPANT_SEATING_ID) as answer_checksum_text,      ps.p_lang_id,      pl.p_lang_name,      pl.file_name_ext from      task t      inner join participant_seating ps on t.VARIANT_CODE = ps.VARIANT_CODE      inner join p_lang pl on ps.p_lang_id = pl.p_lang_id where      t.ID = ?      and ps.PARTICIPANT_ID = ?", new Object[]{taskId.toString(), participantId.toString()}, new DaoRowHandler<TaskMarkup>(taskMarkups, new ValidatableTaskMarkupMapper(session)));
        return taskMarkups.isEmpty() ? null : (ValidatableTaskMarkup)taskMarkups.iterator().next();
    }

    public Boolean participantHasTask(UUID participantId, UUID taskId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int count = jdbcTemplate.queryForInt("select    count(*) from    task t where    t.id = ?    and t.variant_code = (select ps.variant_code from participant_seating ps where ps.participant_id = ?) ", new Object[]{taskId.toString(), participantId.toString()});
        return count == 1;
    }

    public void deleteParticipantAnswers(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("delete from      answer where      participant_seating_id = ? ", new Object[]{participantId.toString()});
    }

    public List<Task> getTestTasks(UUID participantId) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.query("select    tt.id,    tt.variant_code,    tt.position,    tt.label,    tt.type,    tt.part,    tt.xml_text from task tt inner join (      select (          select tt.id          from task tt              inner join variant vv on vv.variant_code = tt.variant_code              inner join participant_seating pst on vv.variant_code = pst.variant_code          where pst.participant_id = ?              and tt.part = p.part          order by tt.position          fetch first 1 row only      ) id      from      (          select t.part          from task t          inner join variant v on v.variant_code = t.variant_code          inner join participant_seating ps on v.variant_code = ps.variant_code          where ps.participant_id = ?          group by t.part      ) p ) tids on tt.id = tids.id", new Object[]{participantId.toString(), participantId.toString()}, new DaoRowHandler<Task>(tasks, new TaskMapper()));
        return tasks;
    }

    public String getTaskXml(UUID taskId, UUID participantId) throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList taskXmls = new ArrayList();
        jdbcTemplate.query("select      t.xml_text from      task t      inner join participant_seating ps on t.VARIANT_CODE = ps.VARIANT_CODE where      t.ID = ?      and ps.PARTICIPANT_ID = ?", new Object[]{taskId.toString(), participantId.toString()}, new DaoRowHandler<String>(taskXmls, new TaskXmlMapperMapper()));
        return taskXmls.size() > 0 ? (String)taskXmls.get(0) : "";
    }

    public class TaskXmlMapperMapper
    extends EntityMapper<String> {
        @Override
        public String toEntity(ResultSet resultSet) throws SQLException {
            try {
                InternalDecryptCipher decrypt = InternalDecryptCipher.getInstance();
                byte[] taskXml = decrypt.process(this.getBlobBytes(resultSet, "xml_text"));
                return new String(taskXml);
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }
    }
}

