/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.dao.SessionFileStorage;
import ru.tssoft.kege.model.VariantMarkupHeader;
import ru.tssoft.kege.security.InternalDecryptCipher;
import ru.tssoft.kege.xml.XmlDomHelper;

public class VariantMarkupHeaderMapper
extends EntityMapper<VariantMarkupHeader> {
    private HttpSession session;

    public VariantMarkupHeaderMapper(HttpSession session) {
        this.session = session;
    }

    @Override
    public VariantMarkupHeader toEntity(ResultSet resultSet) throws SQLException {
        try {
            InternalDecryptCipher decrypt = InternalDecryptCipher.getInstance();
            byte[] variantXml = decrypt.process(this.getBlobBytes(resultSet, "xml_text"));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(variantXml);
            try {
                return this.parseMarkupHeader(inputStream);
            }
            catch (Exception ex) {
                throw new SQLException(ex);
            }
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public VariantMarkupHeader parseMarkupHeader(InputStream variantXml) throws Exception {
        if (variantXml == null) {
            return null;
        }
        VariantMarkupHeader markupHeader = new VariantMarkupHeader();
        XmlDomHelper domHelper = new XmlDomHelper(variantXml);
        NodeList libraryNodes = domHelper.getNodeList("/Variant/Library/@Src");
        ArrayList<String> libraries = new ArrayList<String>();
        for (int i = 0; i < libraryNodes.getLength(); ++i) {
            Node libNode = libraryNodes.item(i);
            libraries.add(libNode.getTextContent());
        }
        markupHeader.setLibraries(libraries);
        Node scriptNode = domHelper.getNode("/Variant/Script");
        markupHeader.setScript(scriptNode == null ? null : scriptNode.getTextContent());
        Node styleNode = domHelper.getNode("/Variant/Style");
        markupHeader.setStyle(styleNode == null ? null : styleNode.getTextContent());
        SessionFileStorage sessionFileStorage = new SessionFileStorage(this.session);
        HashMap<String, String> namesMap = new HashMap<String, String>();
        NodeList nodeList = domHelper.getNodeList("/Variant/Instruction/Files/File");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            String fileName = item.getAttributes().getNamedItem("name").getTextContent();
            String fileGuidName = String.format("%1$s.%2$s", UUID.randomUUID(), FilenameUtils.getExtension((String)fileName));
            namesMap.put(fileName, "file/file/" + fileGuidName);
            if (this.session == null) continue;
            sessionFileStorage.writeFileToSession(fileGuidName, item.getTextContent());
        }
        Node instructionTextNode = domHelper.getNode("/Variant/Instruction/Text");
        StrSubstitutor sub = new StrSubstitutor(namesMap);
        markupHeader.setInstruction(instructionTextNode == null ? null : sub.replace(instructionTextNode.getTextContent()));
        return markupHeader;
    }
}

