/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.exchange;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ZipArchive;

public class ZipHelper {
    public static void packFolder(File folder, OutputStream outputStream) throws IOException {
        int length = folder.getAbsolutePath().lastIndexOf(File.separator);
        String baseName = folder.getAbsolutePath().substring(0, length + 1);
        ArrayList<ArchiveEntry> archiveEntries = new ArrayList<ArchiveEntry>();
        ZipHelper.addFolderToZip(folder, archiveEntries, baseName);
        ZipArchive zipArchive = new ZipArchive();
        zipArchive.pack(outputStream, archiveEntries.iterator());
    }

    public static void unpackFolder(File folder, InputStream inputStream) throws IOException {
        ZipArchive zipArchive = new ZipArchive();
        Iterator<ArchiveEntry> archiveEntries = zipArchive.unpack(inputStream);
        while (archiveEntries.hasNext()) {
            ArchiveEntry archiveEntry = archiveEntries.next();
            String entryName = folder.getCanonicalPath() + File.separatorChar + archiveEntry.getName();
            entryName = entryName.replace('/', File.separatorChar);
            entryName = entryName.replace('\\', File.separatorChar);
            File entryDest = new File(entryName);
            entryDest.getParentFile().mkdirs();
            FileOutputStream entryStream = new FileOutputStream(entryDest, false);
            try {
                entryStream.write(archiveEntry.getBytes());
            }
            catch (IOException ex) {
                entryStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFolderToZip(File folder, List<ArchiveEntry> archiveEntries, String baseName) throws IOException {
        File[] files;
        for (File file : files = folder.listFiles()) {
            if (file.isDirectory()) {
                ZipHelper.addFolderToZip(file, archiveEntries, baseName);
                continue;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileInputStream input = new FileInputStream(file);
            try {
                byte[] buffer = new byte[4096];
                int n = 0;
                while (-1 != (n = ((InputStream)input).read(buffer))) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                ((InputStream)input).close();
            }
            String name = file.getAbsolutePath().substring(baseName.length());
            ArchiveEntry archiveEntry = new ArchiveEntry(name, outputStream.toByteArray());
            archiveEntries.add(archiveEntry);
        }
    }
}

