/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.action.AbstractImportAction;
import ru.tssoft.kege.dao.ExamSharedDao;
import ru.tssoft.kege.dao.FileStorageDao;
import ru.tssoft.kege.exchange.EmptyCipher;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.kim.KimAttachmentExtractor;
import ru.tssoft.kege.kim.KimEntryExtractor;
import ru.tssoft.kege.kim.KimFileInfo;
import ru.tssoft.kege.kim.KimPackage;
import ru.tssoft.kege.kim.KimPdfExtractor;
import ru.tssoft.kege.kim.KimTaskExtractor;
import ru.tssoft.kege.kim.KimVariantExtractor;
import ru.tssoft.kege.kim.MismatchedKimKeyException;
import ru.tssoft.kege.model.ExamInfo;
import ru.tssoft.kege.security.CertificateDecryptCipher;

public class ImportKimAction
extends AbstractImportAction {
    private static final Logger logger = LoggerFactory.getLogger(ImportKimAction.class);
    private static ResourceBundle bundle = ResourceBundle.getBundle(ImportKimAction.class.getName());
    private FileStorageDao storageDao;
    private ExamSharedDao examDao;

    public ImportKimAction(DataSource dataSource, FileStorageDao storageDao, ExamSharedDao examDao) {
        super(dataSource);
        this.storageDao = storageDao;
        this.examDao = examDao;
    }

    public KimFileInfo preloadKim(InputStream kimStream) throws Exception {
        KimPackage pkg = new KimPackage(null, null);
        KimFileInfo fileInfo = pkg.loadInfo(kimStream);
        return fileInfo;
    }

    public void importKim(InputStream kimStream, InputStream keyStream, String password) throws Exception {
        PackageCipher cipher;
        if (StringUtils.isEmpty((CharSequence)System.getProperty("kege.kim.decrypted"))) {
            cipher = new CertificateDecryptCipher();
            try {
                ((CertificateDecryptCipher)cipher).loadKey(keyStream);
            }
            catch (Exception ex) {
                throw new Exception(bundle.getString("badKey"), ex);
            }
        } else {
            cipher = new EmptyCipher();
            logger.warn("\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0448\u0438\u0444\u0440\u0430\u0446\u0438\u044f \u041a\u0418\u041c");
        }
        ExamInfo examInfo = this.examDao.getExamInfo();
        ArrayList<KimEntryExtractor> extractors = new ArrayList<KimEntryExtractor>();
        extractors.add(new KimVariantExtractor(this.dataSource, cipher, examInfo));
        extractors.add(new KimPdfExtractor(this.storageDao, cipher, examInfo));
        extractors.add(new KimTaskExtractor(this.dataSource, cipher, examInfo));
        extractors.add(new KimAttachmentExtractor(this.storageDao));
        KimPackage pkg = new KimPackage(extractors, password);
        try {
            pkg.load(kimStream, cipher);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof MismatchedKimKeyException) {
                throw new Exception(bundle.getString("badKey"), ex);
            }
            throw ex;
        }
    }
}

