/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.kim.ImportKimAction;
import ru.tssoft.kege.kim.TaskDto;
import ru.tssoft.kege.kim.VariantDto;

class ImportKimTestPreparator {
    private static final Logger logger = LoggerFactory.getLogger(ImportKimAction.class);

    ImportKimTestPreparator() {
    }

    public void prepareTaskList(List<VariantDto> variants, List<TaskDto> tasks) throws Exception {
        if (!Boolean.getBoolean("import.kim.correctlength")) {
            return;
        }
        logger.debug("Prepare kim tasks");
        for (VariantDto variantDto : variants) {
            List<TaskDto> tasksA = this.getPartTasks(tasks, variantDto.getVariantCode(), "A");
            this.correctPartTasks(tasks, tasksA, 10, variantDto.getVariantCode());
            List<TaskDto> tasksB = this.getPartTasks(tasks, variantDto.getVariantCode(), "B");
            this.correctPartTasks(tasks, tasksB, 18, variantDto.getVariantCode());
            List<TaskDto> tasksC = this.getPartTasks(tasks, variantDto.getVariantCode(), "C");
            this.correctPartTasks(tasks, tasksC, 4, variantDto.getVariantCode());
        }
    }

    protected List<TaskDto> getPartTasks(List<TaskDto> taskList, String variantCode, String part) throws Exception {
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        for (TaskDto taskDto : taskList) {
            if (!taskDto.getPart().equals(part) || !taskDto.getVariantCode().equals(variantCode)) continue;
            tasks.add(taskDto);
        }
        return tasks;
    }

    protected List<TaskDto> getVariantTasks(List<TaskDto> taskList, String variantCode) throws Exception {
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        for (TaskDto taskDto : taskList) {
            if (!taskDto.getVariantCode().equals(variantCode)) continue;
            tasks.add(taskDto);
        }
        return tasks;
    }

    protected void correctPartTasks(List<TaskDto> taskList, List<TaskDto> partTaskList, int expectedCount, String variantCode) throws Exception {
        if (partTaskList.size() == expectedCount) {
            return;
        }
        TaskDto[] sortedVariantTasksArray = this.sortTasks(this.getVariantTasks(taskList, variantCode));
        if ((partTaskList = Arrays.asList(this.sortTasks(partTaskList))).size() > expectedCount) {
            for (int i = expectedCount; i < partTaskList.size(); ++i) {
                taskList.remove(partTaskList.get(i));
            }
        } else {
            TaskDto lastTask = partTaskList.get(partTaskList.size() - 1);
            String part = lastTask.getLabel().substring(0, 1);
            short lastPosition = sortedVariantTasksArray[sortedVariantTasksArray.length - 1].getPosition();
            for (int i = partTaskList.size(); i < expectedCount; ++i) {
                lastPosition = (short)(lastPosition + 1);
                logger.debug("newTask.position: " + lastPosition);
                logger.debug("newTask.label: " + part + (i + 1));
                logger.debug("newTask.variantCode: " + lastTask.getVariantCode());
                TaskDto newTask = new TaskDto();
                newTask.setId(UUID.randomUUID());
                newTask.setLabel(part + (i + 1));
                newTask.setPart(part);
                newTask.setPosition(lastPosition);
                newTask.setType(lastTask.getType());
                newTask.setVariantCode(lastTask.getVariantCode());
                newTask.setXmlText(lastTask.getXmlText());
                taskList.add(newTask);
            }
        }
    }

    private TaskDto[] sortTasks(List<TaskDto> taskList) throws Exception {
        TaskDto[] tasksArray = taskList.toArray(new TaskDto[0]);
        Arrays.sort(tasksArray, new Comparator<TaskDto>(){

            @Override
            public int compare(TaskDto o1, TaskDto o2) {
                return o1.getPosition() - o2.getPosition();
            }
        });
        return tasksArray;
    }
}

