/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.config.AppConfig;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.exchange.XmlProcessor;
import ru.tssoft.kege.kim.ImportKimAction;
import ru.tssoft.kege.kim.KimEntryExtractor;
import ru.tssoft.kege.kim.KimFileInfo;
import ru.tssoft.kege.metadata.MetadataManager;

public class KimPackage {
    private static final Logger logger = LoggerFactory.getLogger(KimPackage.class);
    private static ResourceBundle bundle = ResourceBundle.getBundle(ImportKimAction.class.getName());
    private String password;
    private List<KimEntryExtractor> extractors;

    public KimPackage(List<KimEntryExtractor> extractors, String password) {
        this.password = password;
        this.extractors = extractors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KimFileInfo loadInfo(InputStream packageStream) throws ExchangeException {
        KimFileInfo result;
        block19: {
            result = null;
            File kimFile = new File(AppConfig.getTempFolder(), UUID.randomUUID().toString());
            try {
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(kimFile);
                    IOUtils.copy((InputStream)packageStream, (OutputStream)fos);
                }
                catch (Exception ex) {
                    throw new ExchangeException(bundle.getString("unpackError"), ex.getMessage(), ex);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ex) {
                            throw new ExchangeException(bundle.getString("unpackError"), ex.getMessage(), ex);
                        }
                    }
                }
                byte[] decodedXml = null;
                try {
                    ZipFile zipFile = new ZipFile(kimFile);
                    decodedXml = Base64.decodeBase64((String)zipFile.getComment());
                }
                catch (Exception ex) {
                    throw new ExchangeException(bundle.getString("unpackError"), ex.getMessage(), ex);
                }
                try {
                    XmlProcessor<Class<KimFileInfo>> xmlProcessor = new XmlProcessor<Class<KimFileInfo>>();
                    List<Class<KimFileInfo>> entityList = xmlProcessor.unmarshal(MetadataManager.getInstance().getMetadata(KimFileInfo.class), new ByteArrayInputStream(decodedXml));
                    if (entityList != null && !entityList.isEmpty()) {
                        result = (KimFileInfo)((Object)entityList.get(0));
                        break block19;
                    }
                    throw new Exception();
                }
                catch (Throwable ex) {
                    throw new ExchangeException(bundle.getString("previewError"), ex.getMessage(), ex);
                }
            }
            finally {
                kimFile.delete();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream packageStream, PackageCipher cipher) throws ExchangeException {
        File kimFile = new File(AppConfig.getTempFolder(), UUID.randomUUID().toString());
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(kimFile);
                IOUtils.copy((InputStream)packageStream, (OutputStream)fos);
            }
            catch (Exception ex) {
                throw new ExchangeException(bundle.getString("unpackError"), ex.getMessage(), ex);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {
                        throw new ExchangeException(bundle.getString("unpackError"), ex.getMessage(), ex);
                    }
                }
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(kimFile);
            }
            catch (Exception ex) {
                throw new ExchangeException(bundle.getString("previewError"), ex.getMessage(), ex);
            }
            try {
                if (!zipFile.isEncrypted()) {
                    throw new ExchangeException(bundle.getString("unpackError"));
                }
                zipFile.setPassword(this.password);
                for (FileHeader fileHeader : zipFile.getFileHeaders()) {
                    if (fileHeader.isDirectory()) continue;
                    fileHeader.setPassword(this.password.toCharArray());
                    ZipInputStream fileStream = zipFile.getInputStream(fileHeader);
                    try {
                        logger.debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 {} ({})", (Object)fileHeader.getFileName(), (Object)cipher);
                        ArchiveEntry archiveEntry = new ArchiveEntry(fileHeader.getFileName(), IOUtils.toByteArray((InputStream)fileStream));
                        this.extractEntry(archiveEntry);
                    }
                    finally {
                        fileStream.close(true);
                    }
                }
            }
            catch (ZipException ex) {
                String message = ex.getMessage();
                if (message.startsWith("Wrong Password")) {
                    throw new ExchangeException(bundle.getString("wrongPassword"), message, ex);
                }
                throw new ExchangeException(bundle.getString("unpackError"), message, ex);
            }
            catch (IOException ex) {
                throw new ExchangeException(bundle.getString("defaultError"), ex.getMessage(), ex);
            }
        }
        finally {
            kimFile.delete();
        }
    }

    private void extractEntry(ArchiveEntry archiveEntry) throws ExchangeException {
        for (KimEntryExtractor entryExtractor : this.extractors) {
            if (!entryExtractor.isExtractable(archiveEntry)) continue;
            entryExtractor.extract(archiveEntry);
        }
    }
}

