/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.admin.persistence.DataMapper;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.exchange.XmlProcessor;
import ru.tssoft.kege.kim.KimVariantExtractor;
import ru.tssoft.kege.kim.TaskDto;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.MetadataManager;
import ru.tssoft.kege.metadata.ValidationException;
import ru.tssoft.kege.model.ExamInfo;
import ru.tssoft.kege.security.InternalEncryptCipher;

public class KimTaskExtractor
extends KimVariantExtractor {
    private static final Logger logger = LoggerFactory.getLogger(KimTaskExtractor.class);
    private static final String TASK_DEFAULT_ERROR = "\u041f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0439 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430";
    private final EntityMetadata<TaskDto> entityMetadata = MetadataManager.getInstance().getMetadata(TaskDto.class);

    public KimTaskExtractor(DataSource dataSource, PackageCipher cipher, ExamInfo examInfo) {
        super(dataSource, cipher, examInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void extract(ArchiveEntry archiveEntry) throws ExchangeException {
        if (!this.isExtractable(archiveEntry)) {
            return;
        }
        try {
            InputStream inputStream = this.getInputStream(archiveEntry);
            XmlProcessor<TaskDto> xmlProcessor = new XmlProcessor<TaskDto>();
            List<TaskDto> tasks = xmlProcessor.unmarshal(this.entityMetadata, inputStream);
            DataMapper<TaskDto> dtoMapper = new DataMapper<TaskDto>(this.entityMetadata, this.dataSource);
            for (TaskDto task : tasks) {
                try {
                    byte[] sourceXml = task.getXmlText();
                    InternalEncryptCipher kimCipher = InternalEncryptCipher.getInstance();
                    byte[] cryptedXml = kimCipher.process(sourceXml);
                    task.setXmlText(cryptedXml);
                    dtoMapper.create(task);
                }
                catch (SQLException ex) {
                    logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' \u0432 \u0411\u0414 ", this.entityMetadata.getEntityName()), (Throwable)ex);
                    throw ex;
                }
                catch (ValidationException ex) {
                    logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' ", this.entityMetadata.getEntityName()), (Throwable)ex);
                    throw ex;
                    return;
                }
            }
        }
        catch (Throwable e) {
            throw new ExchangeException(TASK_DEFAULT_ERROR, e.getMessage(), e);
        }
    }
}

