/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.metadata;

import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.metadata.ColumnFormat;
import ru.tssoft.kege.metadata.ColumnValue;
import ru.tssoft.kege.metadata.FieldColumn;
import ru.tssoft.kege.metadata.UnsupportedTypeConversion;

public class FieldColumnValue {
    private static final Logger logger = LoggerFactory.getLogger(FieldColumnValue.class);
    private FieldColumn fieldColumn;

    public FieldColumnValue(FieldColumn fieldColumn) {
        this.fieldColumn = fieldColumn;
    }

    public Object getColumnValue(Object fieldValue) throws UnsupportedTypeConversion {
        return this.getColumnTypedValue(fieldValue, this.fieldColumn.getColumnType());
    }

    public String getColumnTextValue(Object fieldValue) throws UnsupportedTypeConversion {
        Object textValue = this.getColumnTypedValue(fieldValue, String.class);
        if (textValue == null) {
            textValue = "";
        }
        return (String)textValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getColumnTypedValue(Object fieldValue, Class<?> columnType) throws UnsupportedTypeConversion {
        ColumnValue dictionaryValue;
        if (fieldValue == null) {
            return null;
        }
        Object columnValue = null;
        Class<?> fieldType = this.fieldColumn.getFieldType();
        if (fieldType.equals(String.class)) {
            if (columnType.equals(String.class)) {
                columnValue = fieldValue;
            } else if (columnType.equals(Clob.class)) {
                columnValue = fieldValue;
            } else {
                if (!columnType.equals(Blob.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                columnValue = new ByteArrayInputStream(fieldValue.toString().getBytes());
            }
        } else if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
            if (columnType.equals(Integer.class)) {
                columnValue = fieldValue;
            } else {
                if (!columnType.equals(String.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                columnValue = fieldValue.toString();
            }
        } else if (fieldType.equals(Short.class) || fieldType.equals(Short.TYPE)) {
            if (columnType.equals(Short.class)) {
                columnValue = fieldValue;
            } else {
                if (!columnType.equals(String.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                columnValue = fieldValue.toString();
            }
        } else if (fieldType.equals(java.util.Date.class)) {
            java.util.Date dateValue = (java.util.Date)fieldValue;
            if (columnType.equals(Timestamp.class)) {
                columnValue = new Timestamp(dateValue.getTime());
            } else if (columnType.equals(Date.class)) {
                columnValue = new Date(dateValue.getTime());
            } else if (columnType.equals(Time.class)) {
                columnValue = new Time(dateValue.getTime());
            } else {
                ColumnFormat columnFormat;
                if (!columnType.equals(String.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                String dateFormat = "yyyy-MM-dd HH:mm:ss";
                if (this.fieldColumn.getColumnFormat() != null && !(columnFormat = this.fieldColumn.getColumnFormat()).value().equals("")) {
                    dateFormat = columnFormat.value();
                }
                columnValue = new SimpleDateFormat(dateFormat).format(fieldValue);
            }
        } else if (fieldType.equals(UUID.class)) {
            if (columnType.equals(UUID.class)) {
                columnValue = fieldValue;
            } else {
                if (!columnType.equals(String.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                columnValue = ((UUID)fieldValue).toString();
            }
        } else if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
            if (columnType.equals(String.class)) {
                columnValue = (Boolean)fieldValue != false ? "1" : "0";
            } else if (columnType.equals(Integer.class) || columnType.equals(Short.class)) {
                columnValue = (Boolean)fieldValue != false ? new Integer(1) : new Integer(0);
            } else {
                if (!columnType.equals(Boolean.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                columnValue = fieldValue;
            }
        } else if (fieldType.isEnum()) {
            int ordinalValue = ((Enum)fieldValue).ordinal();
            if (columnType.equals(String.class)) {
                columnValue = String.valueOf(ordinalValue);
            } else if (columnType.equals(Integer.class)) {
                columnValue = ordinalValue;
            } else {
                if (!columnType.equals(Short.class)) throw new UnsupportedTypeConversion(fieldType, columnType);
                columnValue = Short.parseShort(String.valueOf(ordinalValue));
            }
        } else {
            columnValue = fieldType.isArray() && fieldType.getComponentType().equals(Byte.TYPE) ? new ByteArrayInputStream((byte[])fieldValue) : fieldValue;
        }
        if (!columnType.equals(String.class)) return columnValue;
        if (this.fieldColumn.getColumnFormat() == null) return columnValue;
        if (this.fieldColumn.getColumnFormat().dictionary().length <= 0) return columnValue;
        Iterator<ColumnValue> i$ = Arrays.asList(this.fieldColumn.getColumnFormat().dictionary()).iterator();
        do {
            if (!i$.hasNext()) return columnValue;
            dictionaryValue = i$.next();
        } while (!columnValue.toString().equals(dictionaryValue.fieldValue()));
        return dictionaryValue.columnValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getFieldValue(Object columnValue) throws UnsupportedTypeConversion {
        if (columnValue == null) {
            return null;
        }
        Class<?> columnType = columnValue.getClass();
        Class<?> fieldType = this.fieldColumn.getFieldType();
        Object fieldValue = null;
        if (columnValue instanceof String) {
            String stringValue = (String)columnValue;
            if (this.fieldColumn.getColumnFormat() != null && this.fieldColumn.getColumnFormat().dictionary().length > 0) {
                for (ColumnValue dictionaryValue : Arrays.asList(this.fieldColumn.getColumnFormat().dictionary())) {
                    if (!stringValue.equals(dictionaryValue.columnValue())) continue;
                    stringValue = dictionaryValue.fieldValue();
                    break;
                }
            }
            if (fieldType.equals(String.class)) {
                return stringValue;
            }
            if (fieldType.equals(Integer.class)) {
                if (stringValue.isEmpty()) return null;
                Integer n = Integer.parseInt(stringValue);
                return n;
            }
            if (fieldType.equals(Integer.TYPE)) {
                return Integer.parseInt(stringValue);
            }
            if (fieldType.equals(Short.class)) {
                if (stringValue.isEmpty()) return null;
                Short s = Short.parseShort(stringValue);
                return s;
            }
            if (fieldType.equals(Short.TYPE)) {
                return Short.parseShort(stringValue);
            }
            if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                Boolean bl;
                if ("1".equals(stringValue)) {
                    bl = Boolean.TRUE;
                    return bl;
                } else {
                    if (!"0".equals(stringValue)) return null;
                    bl = Boolean.FALSE;
                }
                return bl;
            }
            if (fieldType.equals(java.util.Date.class)) {
                ColumnFormat columnFormat;
                String dateFormat = "yyyy-MM-dd HH:mm:ss";
                if (this.fieldColumn.getColumnFormat() != null && !(columnFormat = this.fieldColumn.getColumnFormat()).value().equals("")) {
                    dateFormat = columnFormat.value();
                }
                try {
                    return new SimpleDateFormat(dateFormat).parse(stringValue);
                }
                catch (ParseException ex) {
                    return fieldValue;
                }
            }
            if (fieldType.equals(UUID.class)) {
                if (stringValue.length() == 38) {
                    stringValue = stringValue.substring(1, 37);
                }
                if (stringValue.equals("")) return null;
                UUID uUID = UUID.fromString(stringValue);
                return uUID;
            }
            if (!fieldType.isEnum()) {
                if (!fieldType.isArray()) throw new UnsupportedTypeConversion(columnType, fieldType);
                if (!fieldType.getComponentType().equals(Byte.TYPE)) throw new UnsupportedTypeConversion(columnType, fieldType);
                return stringValue.getBytes(Charset.forName("UTF-8"));
            }
            try {
                Enum[] values;
                Method valuesMethod = fieldType.getMethod("values", new Class[0]);
                Enum[] arr$ = values = (Enum[])valuesMethod.invoke(null, new Object[0]);
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    Enum enumValue = arr$[i$];
                    if (String.valueOf(enumValue.ordinal()).equals(stringValue)) {
                        return enumValue;
                    }
                    ++i$;
                }
                return fieldValue;
            }
            catch (IllegalAccessException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (IllegalArgumentException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (InvocationTargetException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (NoSuchMethodException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (SecurityException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
        }
        if (columnValue instanceof Integer || columnType.equals(Integer.TYPE)) {
            Integer intValue = (Integer)columnValue;
            if (fieldType.equals(Integer.class)) return columnValue;
            if (fieldType.equals(Integer.TYPE)) {
                return columnValue;
            }
            if (fieldType.equals(Short.class)) return Short.parseShort(intValue.toString());
            if (fieldType.equals(Short.TYPE)) {
                return Short.parseShort(intValue.toString());
            }
            if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                return intValue == 1 ? true : (intValue == 0 ? Boolean.valueOf(false) : null);
            }
            if (!fieldType.isEnum()) throw new UnsupportedTypeConversion(columnType, fieldType);
            try {
                Enum[] values;
                Method valuesMethod = fieldType.getMethod("values", new Class[0]);
                Enum[] arr$ = values = (Enum[])valuesMethod.invoke(null, new Object[0]);
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    Enum enumValue = arr$[i$];
                    if (enumValue.ordinal() == intValue.intValue()) {
                        return enumValue;
                    }
                    ++i$;
                }
                return fieldValue;
            }
            catch (IllegalAccessException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (IllegalArgumentException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (InvocationTargetException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (NoSuchMethodException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
            catch (SecurityException ex) {
                logger.error(String.valueOf(fieldValue), (Throwable)ex);
                return fieldValue;
            }
        }
        if (columnValue instanceof Short || columnType.equals(Short.TYPE)) {
            if (fieldType.equals(Short.class)) return columnValue;
            if (fieldType.equals(Short.TYPE)) return columnValue;
            if (fieldType.equals(Integer.class)) return columnValue;
            if (!fieldType.equals(Integer.TYPE)) throw new UnsupportedTypeConversion(columnType, fieldType);
            return columnValue;
        }
        if (!(columnValue instanceof java.util.Date)) return columnValue;
        java.util.Date dateValue = (java.util.Date)columnValue;
        if (!fieldType.equals(java.util.Date.class)) throw new UnsupportedTypeConversion(columnType, fieldType);
        return new java.util.Date(dateValue.getTime());
    }
}

