/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.FieldColumn;
import ru.tssoft.kege.metadata.FieldColumnValue;

public class ValidationException
extends Exception {
    private String source;
    private List<ValidationException> causes = new ArrayList<ValidationException>();
    private EntityMetadata sourceEntity;
    private FieldColumn sourceColumn;
    private Object value;
    private String entityId;

    public ValidationException(EntityMetadata sourceEntity, Object entity) {
        this.sourceEntity = sourceEntity;
        if (!sourceEntity.getKeyFields().isEmpty()) {
            FieldColumn fieldColumn = sourceEntity.getKeyFields().get(0);
            try {
                Object keyValue = fieldColumn.getValue(entity);
                FieldColumnValue fieldColumnValue = new FieldColumnValue(fieldColumn);
                this.entityId = fieldColumnValue.getColumnTextValue(keyValue);
            }
            catch (Throwable e) {
                Logger.getLogger(ValidationException.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }

    public ValidationException(FieldColumn sourceColumn, Object value, String message) {
        super(message);
        this.sourceColumn = sourceColumn;
        this.value = value;
        this.source = sourceColumn.getFieldName();
    }

    public ValidationException(String source) {
        this.source = source;
    }

    public ValidationException(String source, String message) {
        super(message);
        this.source = source;
    }

    @Deprecated
    public ValidationException() {
    }

    @Deprecated
    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    @Deprecated
    public ValidationException(Throwable cause) {
        super(cause);
    }

    public String getSource() {
        return this.source;
    }

    public void addCause(ValidationException ex) {
        this.causes.add(ex);
        ex.setSourceEntity(this.sourceEntity);
        ex.setEntityId(this.entityId);
    }

    public List<ValidationException> getCauses() {
        return this.causes;
    }

    public FieldColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(FieldColumn sourceColumn) {
        this.sourceColumn = sourceColumn;
        for (ValidationException cause : this.getCauses()) {
            cause.setSourceColumn(sourceColumn);
        }
    }

    public EntityMetadata getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(EntityMetadata sourceEntity) {
        this.sourceEntity = sourceEntity;
        for (ValidationException cause : this.getCauses()) {
            cause.setSourceEntity(sourceEntity);
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
        for (ValidationException cause : this.getCauses()) {
            cause.setEntityId(entityId);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        for (ValidationException cause : this.getCauses()) {
            cause.setValue(value);
        }
    }
}

