/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import ru.tssoft.kege.dao.OnlineWorkstationDao;

public class OnlineWorkstations {
    private int checkedWorkstations;
    private int expectedWorkstations;
    private int uncheckedWorkstations;
    private final List<String> onlineIps;
    private final List<String> offlineIps;

    public OnlineWorkstations(OnlineWorkstationDao onlineWorkstationDao) {
        this.expectedWorkstations = onlineWorkstationDao.getExpectedWorkstations();
        this.checkedWorkstations = onlineWorkstationDao.getIpStatuses() == null ? 0 : onlineWorkstationDao.getIpStatuses().size();
        this.uncheckedWorkstations = this.expectedWorkstations - this.checkedWorkstations;
        if (this.uncheckedWorkstations < 0) {
            this.uncheckedWorkstations = 0;
        }
        this.onlineIps = new ArrayList<String>();
        this.offlineIps = new ArrayList<String>();
        if (onlineWorkstationDao.getIpStatuses() == null) {
            return;
        }
        for (Map.Entry<String, Boolean> ip : onlineWorkstationDao.getIpStatuses().entrySet()) {
            if (ip.getValue().booleanValue()) {
                this.onlineIps.add(ip.getKey());
                continue;
            }
            this.offlineIps.add(ip.getKey());
        }
    }

    public int getCheckedWorkstations() {
        return this.checkedWorkstations;
    }

    public int getExpectedWorkstations() {
        return this.expectedWorkstations;
    }

    public int getUncheckedWorkstations() {
        return this.uncheckedWorkstations;
    }

    public List<String> getOnlineIps() {
        final Collator collator = Collator.getInstance();
        Collections.sort(this.onlineIps, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return collator.compare(s1, s2);
            }
        });
        return this.onlineIps;
    }

    public List<String> getOfflineIps() {
        final Collator collator = Collator.getInstance();
        Collections.sort(this.offlineIps, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return collator.compare(s1, s2);
            }
        });
        return this.offlineIps;
    }
}

