/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.browsercheck.BrowserValidator;
import ru.tssoft.kege.dao.FileStorageDao;
import ru.tssoft.kege.dao.ProtocolDao;
import ru.tssoft.kege.dao.SystemSettingsDao;
import ru.tssoft.kege.model.FileStorage;
import ru.tssoft.kege.model.examstep.ExamStep;
import ru.tssoft.kege.model.examstep.ExamStepAction;
import ru.tssoft.kege.model.examstep.ExamStepState;
import ru.tssoft.kege.model.examstep.ExamStepType;
import ru.tssoft.kege.model.examstep.ExamStepsProvider;
import ru.tssoft.kege.protocol.AuditoriumReadyProtocol;
import ru.tssoft.kege.protocol.ProtocolSoftwareRow;
import ru.tssoft.kege.text.Translitter;

@Component
public class AuditoriumProtocol {
    @Resource(name="dataSource")
    private DataSource dataSource;
    @Autowired
    private SystemSettingsDao systemSettingsDao;
    @Autowired
    private FileStorageDao fileStorageDao;
    @Autowired
    private ProtocolDao protocolDao;
    @Autowired
    private ExamStepsProvider examStepsProvider;
    private static final Logger logger = LoggerFactory.getLogger(AuditoriumProtocol.class);

    public boolean isAvailableForOrganizator() {
        ExamStep[] examSteps;
        boolean available = false;
        for (ExamStep examStep : examSteps = this.examStepsProvider.getExamSteps()) {
            if (!ExamStepType.PrintProtocol.equals((Object)examStep.getStepType()) || !ExamStepState.NotCompleted.equals((Object)examStep.getState()) || !ExamStepAction.Execute.equals((Object)examStep.getAction())) continue;
            available = true;
        }
        return available;
    }

    public boolean render(HttpServletRequest request) {
        boolean isIe = new BrowserValidator().isIe(request.getHeader("User-Agent"));
        String fileName = "\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b_\u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u043e\u0439_\u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438_\u0430\u0443\u0434\u0438\u0442\u043e\u0440\u0438\u0438_\u041f\u041f\u042d";
        try {
            fileName = isIe ? Translitter.translit(fileName) : new String(fileName.getBytes("UTF-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        AuditoriumReadyProtocol protocol = this.protocolDao.getAuditoriumReadyProtocol();
        List<ProtocolSoftwareRow> orgs = this.protocolDao.getProtocolSoftwareList();
        orgs.add(0, new ProtocolSoftwareRow());
        JRBeanCollectionDataSource reportDataSource = new JRBeanCollectionDataSource(orgs);
        Map<String, Object> parameters = this.getProtocolParameters(protocol);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.renderProtocolPdf(parameters, reportDataSource, outputStream);
            byte[] fileBytes = outputStream.toByteArray();
            this.fileStorageDao.storeFile("session_aud_protocol", fileName, new ByteArrayInputStream(fileBytes));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        this.systemSettingsDao.setValue("print_aud_protocol_complete", String.valueOf(true));
        return true;
    }

    public void downloadProtocol(HttpServletResponse response) throws IOException {
        FileStorage fileStorage = this.fileStorageDao.getFileStorage("session_aud_protocol");
        response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", fileStorage.getFileName()));
        response.setHeader("Content-Transfer-Encoding", "binary");
        IOUtils.copy((InputStream)fileStorage.getInputStream(), (OutputStream)response.getOutputStream());
        this.fileStorageDao.deleteFile("session_aud_protocol");
    }

    public void push(HttpSession session) {
        session.setAttribute("print_aud_protocol_complete", (Object)String.valueOf(true));
    }

    public boolean pop(HttpSession session) {
        Object audProtocolReadyObject = session.getAttribute("print_aud_protocol_complete");
        if (audProtocolReadyObject != null) {
            session.removeAttribute("print_aud_protocol_complete");
        }
        return audProtocolReadyObject != null && Boolean.valueOf(audProtocolReadyObject.toString()) != false;
    }

    private Map<String, Object> getProtocolParameters(AuditoriumReadyProtocol protocol) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("regionPart1", protocol.getRegionPart1());
        parameters.put("regionPart2", protocol.getRegionPart2());
        parameters.put("mouoPart1", protocol.getMouoPart1());
        parameters.put("mouoPart2", protocol.getMouoPart2());
        parameters.put("mouoPart3", protocol.getMouoPart3());
        parameters.put("ppePart1", protocol.getPpePart1());
        parameters.put("ppePart2", protocol.getPpePart2());
        parameters.put("ppePart3", protocol.getPpePart3());
        parameters.put("ppePart4", protocol.getPpePart4());
        parameters.put("audPart1", protocol.getAudPart1());
        parameters.put("audPart2", protocol.getAudPart2());
        parameters.put("audPart3", protocol.getAudPart3());
        parameters.put("audPart4", protocol.getAudPart4());
        parameters.put("subjectPart1", protocol.getSubjectPart1());
        parameters.put("subjectPart2", protocol.getSubjectPart2());
        parameters.put("subjectName", protocol.getSubjectName());
        parameters.put("examDatePart1", protocol.getExamDatePart1());
        parameters.put("examDatePart2", protocol.getExamDatePart2());
        parameters.put("examDatePart3", protocol.getExamDatePart3());
        parameters.put("examDatePart4", protocol.getExamDatePart4());
        parameters.put("examDatePart5", protocol.getExamDatePart5());
        parameters.put("examDatePart6", protocol.getExamDatePart6());
        parameters.put("ppeManagerFullName", protocol.getPpeManagerFullName());
        parameters.put("adminFullName", protocol.getAdminFullName());
        parameters.put("shortPpeManagerFullName", protocol.getShortPpeManagerFullName());
        parameters.put("shortAdminFullName", protocol.getShortAdminFullName());
        parameters.put("auditoriumName", protocol.getAuditoriumName());
        parameters.put("subjectFullName", protocol.getSubjectFullName());
        parameters.put("participantsCountPart1", protocol.getParticipantCount1());
        parameters.put("participantsCountPart2", protocol.getParticipantCount2());
        parameters.put("participantsCountPart3", protocol.getParticipantCount3());
        parameters.put("placesCountPart1", protocol.getPlaceCount1());
        parameters.put("placesCountPart2", protocol.getPlaceCount2());
        parameters.put("placesCountPart3", protocol.getPlaceCount3());
        return parameters;
    }

    private void renderProtocolPdf(Map<String, Object> parameters, JRBeanCollectionDataSource dataSource, OutputStream outputStream) throws Exception {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("protocol.jasper");
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)resourceAsStream);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource);
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.exportReport();
    }
}

