/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.ArrayUtils;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.security.RbdCertificateHelper;

public class CertificateEncryptCipher
implements PackageCipher {
    private PublicKey publicKey;
    private Cipher decryptCipher;

    public void loadKey(InputStream keyStoreStream) throws Exception {
        RbdCertificateHelper certificateHelper;
        try {
            certificateHelper = new RbdCertificateHelper(keyStoreStream);
        }
        catch (Exception ex) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043b\u044e\u0447\u0430", ex);
        }
        this.publicKey = certificateHelper.getPublicKey();
        this.decryptCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        this.decryptCipher.init(1, this.publicKey);
    }

    @Override
    public byte[] process(ArchiveEntry entry) throws Exception {
        int l;
        if (entry == null) {
            return new byte[0];
        }
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        keygen.init(128);
        SecretKey key = keygen.generateKey();
        Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipher.init(1, key);
        ByteArrayOutputStream encodedStream = new ByteArrayOutputStream();
        byte[] encryptedKey = this.decryptCipher.doFinal(key.getEncoded());
        this.writeInt(encodedStream, encryptedKey.length);
        AlgorithmParameters params = aesCipher.getParameters();
        byte[] ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
        this.writeInt(encodedStream, ivBytes.length);
        encodedStream.write(encryptedKey);
        encodedStream.write(ivBytes);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(entry.getBytes());
        CipherOutputStream encryptedStream = new CipherOutputStream(encodedStream, aesCipher);
        byte[] buffer = new byte[aesCipher.getBlockSize()];
        while ((l = inputStream.read(buffer)) != -1) {
            encryptedStream.write(buffer, 0, l);
        }
        encryptedStream.close();
        return encodedStream.toByteArray();
    }

    private void writeInt(OutputStream outputStream, int value) throws Exception {
        byte[] bytes = ByteBuffer.allocate(4).putInt(value).array();
        ArrayUtils.reverse((byte[])bytes);
        outputStream.write(bytes);
    }
}

