/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.security;

import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Enumeration;

public class RbdCertificateHelper {
    private static final String defaultPassword = new String(new byte[]{120, 100, 114, 53, 84, 71, 66});
    private KeyStore keyStore = KeyStore.getInstance("PKCS12");
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public RbdCertificateHelper(InputStream keyStoreStream) throws Exception {
        this(keyStoreStream, defaultPassword);
    }

    public RbdCertificateHelper(InputStream keyStoreStream, String password) throws Exception {
        char[] pwd = password.toCharArray();
        this.keyStore.load(keyStoreStream, pwd);
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Key key = this.keyStore.getKey(alias, pwd);
            if (!(key instanceof PrivateKey)) continue;
            this.privateKey = (PrivateKey)key;
            Certificate cert = this.keyStore.getCertificate(alias);
            if (cert == null) break;
            this.publicKey = cert.getPublicKey();
            break;
        }
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

