/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.servlet;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.servlet.DbEncryptionFilter;
import ru.tssoft.kege.servlet.DbFilterBase;
import ru.tssoft.kege.servlet.DbNotEmptyFilter;

public class CompositeDbFilter
extends DbFilterBase {
    private static final Logger logger = LoggerFactory.getLogger(CompositeDbFilter.class);
    private DbFilterBase[] filters = new DbFilterBase[]{new DbNotEmptyFilter(), new DbEncryptionFilter()};

    @Override
    public void init(FilterConfig fc) throws ServletException {
        logger.debug("#init() enter");
        super.init(fc);
        for (DbFilterBase filter : this.filters) {
            logger.debug("\u0412\u044b\u0437\u043e\u0432 init() \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430 " + filter.getClass().getName());
            filter.init(fc);
        }
        logger.debug("#init() exit");
    }

    @Override
    protected boolean doFilterInternal(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (DbFilterBase filter : this.filters) {
            if (!filter.doFilterInternal(request, response)) continue;
            logger.debug(String.format("\u0424\u0438\u043b\u044c\u0442\u0440 %s \u0432\u0435\u0440\u043d\u0443\u043b true", filter.getClass().getName()));
            return true;
        }
        return false;
    }
}

