/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.servlet;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.dao.StartExamDao;
import ru.tssoft.kege.servlet.DbFilterBase;

public class DbNotEmptyFilter
extends DbFilterBase {
    private static final String EMPTY_DB_REDIRECT_PAGE = "/emptydb.html";
    private static final Logger logger = LoggerFactory.getLogger(DbNotEmptyFilter.class);
    private StartExamDao startExamDao = new StartExamDao();

    @Override
    public void init(FilterConfig fc) throws ServletException {
        super.init(fc);
        this.startExamDao.setDataSource(this.dataSource);
    }

    @Override
    protected boolean doFilterInternal(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!request.getRequestURI().endsWith(EMPTY_DB_REDIRECT_PAGE) && !this.startExamDao.isDbPrepared()) {
            logger.info(String.format("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d URI '%s'", request.getRequestURI()));
            logger.info("\u0411\u0414 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430, \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442 \u043d\u0430 /emptydb.html");
            response.sendRedirect(EMPTY_DB_REDIRECT_PAGE);
            return true;
        }
        return false;
    }
}

