/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlDomHelper {
    private DocumentBuilder builder = null;
    private Document dom;

    public XmlDomHelper(InputStream sourceStream) {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        try {
            this.builder = domFactory.newDocumentBuilder();
            if (sourceStream.available() > 0) {
                this.dom = this.builder.parse(sourceStream);
            } else {
                DOMImplementation impl = this.builder.getDOMImplementation();
                this.dom = impl.createDocument(null, null, null);
            }
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlDomHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XmlDomHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlDomHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Element createElement(Element parent, String name) {
        Element childElement = this.dom.createElement(name);
        parent.appendChild(childElement);
        return childElement;
    }

    public void createTextNode(Element parent, String text) {
        Text textNode = this.dom.createTextNode(text);
        parent.appendChild(textNode);
    }

    public void createCharDataNode(Element parent, String text) {
        CDATASection cdata = this.dom.createCDATASection(text);
        parent.appendChild(cdata);
    }

    public void transform(Transformer transformer, OutputStream outputStream) {
        this.dom.setXmlStandalone(true);
        DOMSource domSource = new DOMSource(this.dom);
        StreamResult sr = new StreamResult(outputStream);
        try {
            transformer.transform(domSource, sr);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XmlDomHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Node getNode(String xpathExp) {
        return (Node)this.getByXpath(this.dom, xpathExp, XPathConstants.NODE);
    }

    public NodeList getNodeList(String xpathExp) {
        return (NodeList)this.getByXpath(this.dom, xpathExp, XPathConstants.NODESET);
    }

    public Node getNode(Node rootNode, String xpathExp) {
        return (Node)this.getByXpath(rootNode, xpathExp, XPathConstants.NODE);
    }

    public NodeList getNodeList(Node rootNode, String xpathExp) {
        return (NodeList)this.getByXpath(rootNode, xpathExp, XPathConstants.NODESET);
    }

    private Object getByXpath(Node rootNode, String xpathExp, QName qName) {
        Object result = null;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(xpathExp);
            result = expr.evaluate(rootNode, qName);
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(XmlDomHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public Element accessElement(String fullPath) {
        String[] pathElements = fullPath.split("/");
        if (pathElements.length <= 1) {
            return null;
        }
        String rootName = pathElements[1];
        Element element = this.dom.getDocumentElement();
        if (element == null) {
            element = this.dom.createElement(rootName);
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            this.dom.appendChild(element);
        }
        for (int i = 2; i < pathElements.length; ++i) {
            element = this.readElement(element, pathElements[i]);
        }
        return element;
    }

    private Element readElement(Element parentElement, String elementName) {
        NodeList elements = parentElement.getElementsByTagName(elementName);
        Element childElement = elements.getLength() > 0 ? (Element)elements.item(0) : this.createElement(parentElement, elementName);
        return childElement;
    }

    public static String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public byte[] toByteArray() throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.transform(transformer, outputStream);
        return outputStream.toByteArray();
    }
}

