/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.admin.persistence;

import java.io.InputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedParameterStatement {
    private final PreparedStatement statement;
    private final Map indexMap = new HashMap();

    public NamedParameterStatement(Connection connection, String query) throws SQLException {
        String parsedQuery = NamedParameterStatement.parse(query, this.indexMap);
        this.statement = connection.prepareStatement(parsedQuery);
    }

    static final String parse(String query, Map paramMap) {
        int length = query.length();
        StringBuffer parsedQuery = new StringBuffer(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int n = query.charAt(i);
            if (inSingleQuote) {
                if (n == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (n == 34) {
                    inDoubleQuote = false;
                }
            } else if (n == 39) {
                inSingleQuote = true;
            } else if (n == 34) {
                inDoubleQuote = true;
            } else if (n == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                }
                String name = query.substring(i + 1, j);
                n = 63;
                i += name.length();
                LinkedList<Integer> indexList = (LinkedList<Integer>)paramMap.get(name);
                if (indexList == null) {
                    indexList = new LinkedList<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(new Integer(index));
                ++index;
            }
            parsedQuery.append((char)n);
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            List list = (List)entry.getValue();
            int[] indexes = new int[list.size()];
            int i = 0;
            for (Integer x : list) {
                indexes[i++] = x;
            }
            entry.setValue(indexes);
        }
        return parsedQuery.toString();
    }

    private int[] getIndexes(String name) {
        int[] indexes = (int[])this.indexMap.get(name);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter not found: " + name);
        }
        return indexes;
    }

    public void setObject(String name, Object value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setObject(indexes[i], value);
        }
    }

    public void setObjectOrNull(String name, Object value, Class<?> type) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            if (value != null) {
                this.statement.setObject(indexes[i], value);
                continue;
            }
            int sqlType = 1111;
            if (type.equals(String.class)) {
                sqlType = 12;
            } else if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                sqlType = 5;
            } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                sqlType = 4;
            } else if (type.equals(java.util.Date.class) || type.equals(Timestamp.class)) {
                sqlType = 93;
            } else if (type.equals(Date.class)) {
                sqlType = 91;
            } else if (type.equals(Time.class)) {
                sqlType = 92;
            } else if (type.equals(Clob.class)) {
                sqlType = 2005;
            } else if (type.equals(Blob.class)) {
                sqlType = 2004;
            }
            this.statement.setNull(indexes[i], sqlType);
        }
    }

    public void setString(String name, String value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setString(indexes[i], value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setInt(indexes[i], value);
        }
    }

    public void setLong(String name, long value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setLong(indexes[i], value);
        }
    }

    public void setTimestamp(String name, Timestamp value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setTimestamp(indexes[i], value);
        }
    }

    public void setClob(String name, Object value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        StringReader reader = new StringReader(value.toString());
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setClob(indexes[i], reader);
        }
    }

    public void setBlob(String name, Object value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        InputStream blobStream = null;
        if (value instanceof InputStream) {
            blobStream = (InputStream)value;
        } else if (value instanceof Blob) {
            blobStream = ((Blob)value).getBinaryStream();
        }
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setBlob(indexes[i], blobStream);
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }
}

