/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

public class AbstractDao {
    @Resource(name="dataSource")
    protected DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected int queryAndReturnIdentity(String sql, Object[] args) {
        int n;
        Connection con = DataSourceUtils.getConnection((DataSource)this.dataSource);
        Statement stmt = null;
        try {
            PreparedStatement ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    if (arg instanceof SqlParameterValue) {
                        SqlParameterValue paramValue = (SqlParameterValue)arg;
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (SqlParameter)paramValue, (Object)paramValue.getValue());
                        continue;
                    }
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, (Object)arg);
                }
            }
            ps.executeUpdate();
            stmt = con.createStatement();
            stmt.execute("CALL IDENTITY();");
            ResultSet resultSet = stmt.getResultSet();
            resultSet.next();
            n = resultSet.getInt(1);
        }
        catch (SQLException ex) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
                con = null;
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement((Statement)stmt);
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
        return n;
    }

    protected ResultSet select(String sql, Object[] args) {
        Connection con = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            PreparedStatement ps = con.prepareStatement(sql);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    if (arg instanceof SqlParameterValue) {
                        SqlParameterValue paramValue = (SqlParameterValue)arg;
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (SqlParameter)paramValue, (Object)paramValue.getValue());
                        continue;
                    }
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, (Object)arg);
                }
            }
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        catch (SQLException ex) {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
            con = null;
            throw new RuntimeException(ex);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
        }
    }
}

