/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.model.PollQuestion;

@Component
public class PollDao
extends AbstractDao {
    public void saveAnswer(final PollQuestion question, final short answer) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection cnctn) throws SQLException {
                String query = "insert into poll (poll_id, question, answer, answer_date) values (?, ?, ?, current_timestamp)";
                PreparedStatement ps = cnctn.prepareStatement(query);
                ps.setString(1, UUID.randomUUID().toString());
                ps.setString(2, question.name());
                ps.setShort(3, answer);
                return ps;
            }
        });
    }

    public void saveParticipantPoll(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("update participant_seating set    poll_saved = 1 where    participant_id = ? ", new Object[]{participantId.toString()});
    }

    public Boolean pollAnswered(UUID participantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        return (Boolean)jdbcTemplate.queryForObject("select case when poll_saved = 1 then true else false end from    participant_seating where participant_id = ?", new Object[]{participantId.toString()}, Boolean.class);
    }
}

