/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.dao.AbstractDao;

@Component
public class StartExamDao
extends AbstractDao {
    public Date getExamDate() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Date examDate = (Date)jdbcTemplate.queryForObject("select exam_date from exam", Date.class);
        return examDate;
    }

    public String getExamDateString() {
        return new SimpleDateFormat("dd.MM.yyyy").format(this.getExamDate());
    }

    public String getSubjectName() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String subjectName = (String)jdbcTemplate.queryForObject("select subject_name from exam", String.class);
        return subjectName;
    }

    public String getAuditoriumName() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        return (String)jdbcTemplate.queryForObject("select auditorium_name from auditorium where active = 1 fetch first row only", String.class);
    }

    public UUID getAuditoriumId() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String id = (String)jdbcTemplate.queryForObject("select auditorium_id from auditorium where active = 1 fetch first row only", String.class);
        return UUID.fromString(id);
    }

    public boolean isDbPrepared() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int count = jdbcTemplate.queryForInt("select  count(*) from      auditorium a join participant_seating ps on a.auditorium_id = ps.auditorium_id     join user_info u on 1 = 1 and u.login = 'admin' where a.active = 1");
        return count > 0;
    }
}

