/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.model.Task;
import ru.tssoft.kege.security.InternalDecryptCipher;

public class TaskMapper
extends EntityMapper<Task> {
    @Override
    public Task toEntity(ResultSet resultSet) throws SQLException {
        Task task = new Task();
        task.setId(this.getUuid(resultSet, "id"));
        task.setVariantCode(this.getString(resultSet, "variant_code"));
        task.setPosition(this.getShort(resultSet, "position"));
        task.setLabel(this.getString(resultSet, "label"));
        task.setType(this.getString(resultSet, "type"));
        task.setPart(this.getString(resultSet, "part"));
        try {
            InternalDecryptCipher decrypt = InternalDecryptCipher.getInstance();
            byte[] taskXml = decrypt.process(this.getBlobBytes(resultSet, "xml_text"));
            task.setXmlText(new String(taskXml));
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
        return task;
    }
}

