/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.exchange;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.exchange.ExchangePackage;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.exchange.XmlEntity;
import ru.tssoft.kege.exchange.XmlProcessor;
import ru.tssoft.kege.exchange.ZipArchive;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.MetadataManager;
import ru.tssoft.kege.xml.BomHelper;

public class XmlPackage
implements ExchangePackage {
    private static final Logger logger = LoggerFactory.getLogger(XmlPackage.class);
    protected Map<String, ArchiveEntry> archiveSources = new HashMap<String, ArchiveEntry>();

    @Override
    public void pack(OutputStream packageStream, PackageCipher cipher) throws ExchangeException {
        ZipArchive zipArchive = new ZipArchive();
        try {
            for (ArchiveEntry archiveEntry : this.archiveSources.values()) {
                byte[] content = cipher.process(archiveEntry);
                archiveEntry.setBytes(content);
            }
            zipArchive.pack(packageStream, this.archiveSources.values().iterator());
        }
        catch (Throwable ex) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u0430\u043a\u0435\u0442\u0430", ex);
            throw new ExchangeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u0430\u043a\u0435\u0442\u0430", ex);
        }
    }

    @Override
    public void unpack(InputStream packageStream, PackageCipher cipher) throws ExchangeException {
        ZipArchive zipArchive = new ZipArchive();
        try {
            Iterator<ArchiveEntry> iterator = zipArchive.unpack(packageStream);
            this.archiveSources.clear();
            while (iterator.hasNext()) {
                ArchiveEntry archiveEntry = iterator.next();
                logger.debug("\u0420\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 {} ({})", (Object)archiveEntry.getName(), (Object)cipher);
                byte[] content = cipher.process(archiveEntry);
                content = BomHelper.removeBomAndTrim(content);
                archiveEntry.setBytes(content);
                this.archiveSources.put(archiveEntry.getName(), archiveEntry);
            }
        }
        catch (ExchangeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043f\u0430\u043a\u0435\u0442\u0430", ex);
            throw new ExchangeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u043f\u0430\u043a\u0435\u0442\u0430", ex);
        }
    }

    @Override
    public <T> List<T> getEntityList(Class<T> entityClass) throws ExchangeException {
        if (!entityClass.isAnnotationPresent(XmlEntity.class)) {
            return null;
        }
        EntityMetadata<Class<XmlEntity>> entityMetadata = MetadataManager.getInstance().getMetadata(entityClass);
        XmlEntity xmlEntity = entityMetadata.getAnnotation(XmlEntity.class);
        ArrayList<Class<T>> entityList = new ArrayList<Class<T>>();
        XmlProcessor<Class<XmlEntity>> xmlProcessor = new XmlProcessor<Class<XmlEntity>>();
        for (String filename : this.archiveSources.keySet()) {
            if (!this.isEntryNameMatch(filename, xmlEntity)) continue;
            ArchiveEntry archiveEntry = this.archiveSources.get(filename);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(archiveEntry.getBytes());
            try {
                entityList.addAll(xmlProcessor.unmarshal(entityMetadata, inputStream));
            }
            catch (Throwable e) {
                throw new ExchangeException(e.getMessage());
            }
        }
        return entityList;
    }

    boolean isEntryNameMatch(String entryName, XmlEntity xmlEntity) {
        if (xmlEntity.wildcard()) {
            String regexp = xmlEntity.source();
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(entryName);
            return matcher.matches();
        }
        return entryName.equals(xmlEntity.source());
    }

    @Override
    public <T> void setEntityList(List<T> entityList) throws ExchangeException {
        if (entityList == null || entityList.isEmpty()) {
            return;
        }
        EntityMetadata<XmlEntity> entityMetadata = MetadataManager.getInstance().getMetadata(entityList.get(0));
        XmlEntity xmlEntity = entityMetadata.getAnnotation(XmlEntity.class);
        if (xmlEntity == null) {
            return;
        }
        ArchiveEntry archiveEntry = this.archiveSources.get(xmlEntity.source());
        if (archiveEntry == null) {
            archiveEntry = new ArchiveEntry(xmlEntity.source(), new byte[0]);
        }
        XmlProcessor<List<T>> xmlProcessor = new XmlProcessor<List<T>>();
        byte[] updatedContent = xmlProcessor.marshal((EntityMetadata<List<T>>)entityMetadata, entityList, archiveEntry.getBytes());
        archiveEntry = new ArchiveEntry(xmlEntity.source(), updatedContent);
        this.archiveSources.put(xmlEntity.source(), archiveEntry);
    }

    @Override
    public <T> void setEntity(T entity) throws ExchangeException {
        if (entity == null) {
            return;
        }
        EntityMetadata<XmlEntity> entityMetadata = MetadataManager.getInstance().getMetadata(entity);
        XmlEntity xmlEntity = entityMetadata.getAnnotation(XmlEntity.class);
        if (xmlEntity == null) {
            return;
        }
        ArchiveEntry archiveEntry = this.archiveSources.get(xmlEntity.source());
        if (archiveEntry == null) {
            archiveEntry = new ArchiveEntry(xmlEntity.source(), new byte[0]);
        }
        XmlProcessor<XmlEntity> xmlProcessor = new XmlProcessor<XmlEntity>();
        byte[] updatedContent = xmlProcessor.marshal(entityMetadata, (XmlEntity)entity, archiveEntry.getBytes());
        archiveEntry = new ArchiveEntry(xmlEntity.source(), updatedContent);
        this.archiveSources.put(archiveEntry.getName(), archiveEntry);
    }

    public void setEntity(String name, byte[] content) {
        ArchiveEntry archiveEntry = new ArchiveEntry(name, content);
        this.archiveSources.put(archiveEntry.getName(), archiveEntry);
    }

    public Map<String, ArchiveEntry> getArchiveSources() {
        return Collections.unmodifiableMap(this.archiveSources);
    }
}

