/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.exchange;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.tssoft.kege.exchange.CharData;
import ru.tssoft.kege.exchange.XPath;
import ru.tssoft.kege.exchange.XmlEntity;
import ru.tssoft.kege.exchange.XmlNodeText;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.Export;
import ru.tssoft.kege.metadata.FieldColumn;
import ru.tssoft.kege.metadata.FieldColumnValue;
import ru.tssoft.kege.metadata.UnsupportedTypeConversion;
import ru.tssoft.kege.metadata.ValidationException;
import ru.tssoft.kege.xml.XmlDomHelper;

public class XmlProcessor<T> {
    private static final Logger logger = LoggerFactory.getLogger(XmlProcessor.class);

    public byte[] marshal(EntityMetadata<T> entityMetadata, List<T> entities, byte[] bytes) {
        XmlEntity xmlEntity = entityMetadata.getAnnotation(XmlEntity.class);
        if (xmlEntity == null || xmlEntity.xpath().isEmpty() || xmlEntity.element().isEmpty()) {
            return bytes;
        }
        XmlDomHelper domHelper = new XmlDomHelper(new ByteArrayInputStream(bytes));
        Element entitiesElement = domHelper.accessElement(xmlEntity.xpath());
        for (T entity : entities) {
            boolean ignored = false;
            Iterator<FieldColumn> iterator = entityMetadata.getAnnotatedFields(Export.class).iterator();
            block7: while (!ignored && iterator.hasNext()) {
                FieldColumn fieldColumn = iterator.next();
                try {
                    FieldColumnValue columnValue = new FieldColumnValue(fieldColumn);
                    Object value = fieldColumn.getValue(entity);
                    String textValue = columnValue.getColumnTextValue(value);
                    Export export = fieldColumn.getAnnotation(Export.class);
                    for (String ignoreValue : export.ignoreValues()) {
                        if (!ignoreValue.equals(textValue)) continue;
                        ignored = true;
                        continue block7;
                    }
                }
                catch (ValidationException ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
            }
            if (ignored) continue;
            Element entityElement = domHelper.createElement(entitiesElement, xmlEntity.element());
            for (FieldColumn fieldColumn : entityMetadata.getAnnotatedFields(XmlElement.class)) {
                XmlElement xmlElement = fieldColumn.getAnnotation(XmlElement.class);
                Element fieldElement = domHelper.createElement(entityElement, xmlElement.name());
                try {
                    FieldColumnValue columnValue = new FieldColumnValue(fieldColumn);
                    Object value = fieldColumn.getValue(entity);
                    if (value != null) {
                        String textValue = columnValue.getColumnTextValue(value);
                        if (!fieldColumn.isAnnotated(CharData.class)) {
                            domHelper.createTextNode(fieldElement, textValue);
                            continue;
                        }
                        domHelper.createCharDataNode(fieldElement, textValue);
                        continue;
                    }
                    fieldElement.setAttribute("xsi:nil", "true");
                }
                catch (ValidationException ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
            }
        }
        return this.marshalDom(domHelper);
    }

    public byte[] marshal(EntityMetadata<T> entityMetadata, T entity, byte[] bytes) {
        XmlEntity xmlEntity = entityMetadata.getAnnotation(XmlEntity.class);
        if (xmlEntity == null || xmlEntity.element().isEmpty()) {
            return bytes;
        }
        XmlDomHelper domHelper = new XmlDomHelper(new ByteArrayInputStream(bytes));
        Element entityElement = domHelper.accessElement(xmlEntity.xpath() + "/" + xmlEntity.element());
        for (FieldColumn fieldColumn : entityMetadata.getAnnotatedFields(XmlElement.class)) {
            XmlElement xmlElement = fieldColumn.getAnnotation(XmlElement.class);
            Element fieldElement = domHelper.createElement(entityElement, xmlElement.name());
            try {
                FieldColumnValue columnValue = new FieldColumnValue(fieldColumn);
                Object value = fieldColumn.getValue(entity);
                String textValue = columnValue.getColumnTextValue(value);
                domHelper.createTextNode(fieldElement, textValue);
            }
            catch (ValidationException ex) {
                logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
            }
            catch (UnsupportedTypeConversion ex) {
                logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
            }
        }
        return this.marshalDom(domHelper);
    }

    byte[] marshalDom(XmlDomHelper domHelper) throws IllegalArgumentException, TransformerFactoryConfigurationError {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            logger.debug(null, (Throwable)ex);
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        domHelper.transform(transformer, outputStream);
        return outputStream.toByteArray();
    }

    public List<T> unmarshal(EntityMetadata<T> entityMetadata, InputStream stream) throws Throwable {
        ArrayList<T> entities = new ArrayList<T>();
        HashMap<String, FieldColumn> fieldMap = new HashMap<String, FieldColumn>();
        for (FieldColumn fieldColumn : entityMetadata.getAnnotatedFields(XmlElement.class)) {
            XmlElement xmlElement = fieldColumn.getAnnotation(XmlElement.class);
            fieldMap.put(xmlElement.name(), fieldColumn);
        }
        for (FieldColumn fieldColumn : entityMetadata.getAnnotatedFields(XmlAttribute.class)) {
            XmlAttribute xmlAttribute = fieldColumn.getAnnotation(XmlAttribute.class);
            fieldMap.put(xmlAttribute.name(), fieldColumn);
        }
        XmlEntity xmlEntity = entityMetadata.getAnnotation(XmlEntity.class);
        String xpath = String.format("%s/%s", xmlEntity.xpath(), xmlEntity.element());
        XmlDomHelper domHelper = new XmlDomHelper(stream);
        NodeList entityNodes = domHelper.getNodeList(xpath);
        for (int i = 0; i < entityNodes.getLength(); ++i) {
            T entity;
            try {
                entity = entityMetadata.createEntity();
            }
            catch (ValidationException ex) {
                logger.error(entityMetadata.getEntityClassName(), (Throwable)ex);
                continue;
            }
            Node entityNode = entityNodes.item(i);
            NodeList fieldNodes = entityNode.getChildNodes();
            for (int j = 0; j < fieldNodes.getLength(); ++j) {
                FieldColumn fieldColumn;
                Node fieldNode = fieldNodes.item(j);
                if (fieldNode.getNodeType() != 1 || (fieldColumn = (FieldColumn)fieldMap.get(fieldNode.getNodeName())) == null) continue;
                try {
                    FieldColumnValue fieldColumnValue = new FieldColumnValue(fieldColumn);
                    Object fieldValue = fieldColumnValue.getFieldValue(fieldNode.getTextContent());
                    fieldColumn.setValue(entity, fieldValue);
                    continue;
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                    continue;
                }
                catch (ValidationException ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
            }
            NamedNodeMap attributes = entityNode.getAttributes();
            if (attributes != null) {
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node attribute = attributes.item(j);
                    FieldColumn fieldColumn = (FieldColumn)fieldMap.get(attribute.getNodeName());
                    if (fieldColumn == null) continue;
                    try {
                        FieldColumnValue fieldColumnValue = new FieldColumnValue(fieldColumn);
                        Object fieldValue = fieldColumnValue.getFieldValue(attribute.getTextContent());
                        fieldColumn.setValue(entity, fieldValue);
                        continue;
                    }
                    catch (UnsupportedTypeConversion ex) {
                        logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                        continue;
                    }
                    catch (ValidationException ex) {
                        logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                    }
                }
            }
            String nodeContent = XmlDomHelper.nodeToString(entityNode);
            List<FieldColumn> fieldColumns = entityMetadata.getAnnotatedFields(XmlNodeText.class);
            for (FieldColumn fieldColumn : fieldColumns) {
                try {
                    FieldColumnValue fieldColumnValue = new FieldColumnValue(fieldColumn);
                    Object fieldValue = fieldColumnValue.getFieldValue(nodeContent);
                    fieldColumn.setValue(entity, fieldValue);
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
                catch (ValidationException ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
            }
            List<FieldColumn> xpathColumns = entityMetadata.getAnnotatedFields(XPath.class);
            for (FieldColumn fieldColumn : xpathColumns) {
                try {
                    XPath columnXpath = fieldColumn.getAnnotation(XPath.class);
                    String valueXpath = columnXpath.value();
                    Node valueNode = domHelper.getNode(valueXpath);
                    FieldColumnValue fieldColumnValue = new FieldColumnValue(fieldColumn);
                    Object fieldValue = fieldColumnValue.getFieldValue(valueNode.getTextContent());
                    fieldColumn.setValue(entity, fieldValue);
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
                catch (ValidationException ex) {
                    logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                }
            }
            entities.add(entity);
        }
        return entities;
    }
}

