/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.ByteArrayInputStream;
import ru.tssoft.kege.dao.FileStorageDao;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.kim.KimEntryExtractor;

public class KimAttachmentExtractor
implements KimEntryExtractor {
    private FileStorageDao storageDao;

    public KimAttachmentExtractor(FileStorageDao storageDao) {
        this.storageDao = storageDao;
    }

    @Override
    public boolean isExtractable(ArchiveEntry archiveEntry) {
        return archiveEntry.getName().contains("_attachments/");
    }

    @Override
    public void extract(ArchiveEntry archiveEntry) throws ExchangeException {
        if (!this.isExtractable(archiveEntry)) {
            return;
        }
        String fileId = archiveEntry.getName();
        ByteArrayInputStream fileInputStream = new ByteArrayInputStream(archiveEntry.getBytes());
        try {
            this.storageDao.storeFile(fileId, fileId, fileInputStream);
        }
        catch (Exception ex) {
            throw new ExchangeException(ex.getMessage(), ex);
        }
    }
}

