/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.tssoft.kege.exchange.ExchangeEntity;
import ru.tssoft.kege.exchange.XmlEntity;
import ru.tssoft.kege.exchange.XmlNodeText;
import ru.tssoft.kege.metadata.ColumnFormat;
import ru.tssoft.kege.metadata.ColumnType;
import ru.tssoft.kege.metadata.EntityField;
import ru.tssoft.kege.metadata.PrivateInfo;
import ru.tssoft.kege.xml.XmlDomHelper;

@Entity
@ExchangeEntity(value="\u0412\u0430\u0440\u0438\u0430\u043d\u0442")
@Table(name="VARIANT")
@XmlEntity(source="\\d+_\\d+_\\d+\\.\\w+", wildcard=true, xpath="", element="Variant")
public class VariantDto {
    @Id
    @Basic(optional=false)
    @Column(name="VARIANT_CODE", nullable=false, length=36)
    @ColumnType(value=String.class)
    @XmlAttribute(name="VariantCode")
    private String variantCode;
    @Basic(optional=false)
    @Column(name="ZONE_CODE", nullable=false)
    @XmlAttribute(name="ZoneCode")
    private short zoneCode;
    @Basic(optional=false)
    @Column(name="TECHNOLOGY_CODE", nullable=false)
    @XmlAttribute(name="TechnologyCode")
    private short technologyCode;
    @EntityField
    @XmlAttribute(name="ExamGlobalId")
    private int examGlobalId;
    @EntityField
    @XmlAttribute(name="Region")
    private int region;
    @EntityField
    @ColumnFormat(value="dd.MM.yyyy")
    @Temporal(value=TemporalType.DATE)
    @XmlAttribute(name="ExamDate")
    private Date examDate;
    @PrivateInfo
    @Basic(optional=false)
    @Column(name="XML_TEXT", nullable=false, length=0x7FFFFFFF)
    @ColumnType(value=Blob.class)
    @XmlNodeText
    private byte[] xmlText;
    @EntityField
    @XmlElement(name="PDF")
    private String pdf;

    public void refineXmlText() throws Exception {
        if (this.xmlText == null) {
            return;
        }
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(this.xmlText));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        XPathExpression expr = xPath.compile("/Variant");
        Node variant = (Node)expr.evaluate(doc, XPathConstants.NODE);
        expr = xPath.compile("/Variant/Item");
        NodeList tasks = (NodeList)expr.evaluate(variant, XPathConstants.NODESET);
        for (int i = 0; i < tasks.getLength(); ++i) {
            variant.removeChild(tasks.item(i));
        }
        this.xmlText = XmlDomHelper.nodeToString(variant).getBytes("UTF-8");
    }

    public byte[] getXmlText() {
        return this.xmlText;
    }

    public void setXmlText(byte[] xmlText) {
        this.xmlText = xmlText;
    }

    public short getTechnologyCode() {
        return this.technologyCode;
    }

    public String getVariantCode() {
        return this.variantCode;
    }

    public short getZoneCode() {
        return this.zoneCode;
    }

    public int getExamGlobalId() {
        return this.examGlobalId;
    }

    public void setExamGlobalId(int examGlobalId) {
        this.examGlobalId = examGlobalId;
    }

    public void setVariantCode(String variantCode) {
        this.variantCode = variantCode;
    }

    public void setZoneCode(short zoneCode) {
        this.zoneCode = zoneCode;
    }

    public void setTechnologyCode(short technologyCode) {
        this.technologyCode = technologyCode;
    }

    public String getPdf() {
        return this.pdf;
    }

    public void setPdf(String pdf) {
        this.pdf = pdf;
    }

    public int getRegion() {
        return this.region;
    }

    public void setRegion(int region) {
        this.region = region;
    }

    public Date getExamDate() {
        return this.examDate;
    }

    public void setExamDate(Date examDate) {
        this.examDate = examDate;
    }
}

