/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.exchange.ExchangeEntity;
import ru.tssoft.kege.exchange.SkipValidation;
import ru.tssoft.kege.metadata.Cache;
import ru.tssoft.kege.metadata.CreateTimestamp;
import ru.tssoft.kege.metadata.Deleted;
import ru.tssoft.kege.metadata.EntityField;
import ru.tssoft.kege.metadata.FieldColumn;
import ru.tssoft.kege.metadata.FieldColumnValue;
import ru.tssoft.kege.metadata.RegionField;
import ru.tssoft.kege.metadata.UniqueConstraintCheck;
import ru.tssoft.kege.metadata.UpdateTimestamp;
import ru.tssoft.kege.metadata.Validate;
import ru.tssoft.kege.metadata.ValidationCheck;
import ru.tssoft.kege.metadata.ValidationException;

public final class EntityMetadata<E> {
    public static final String VALIDATION_MAGIC = "fct.schools.skipValidation";
    private static final Logger logger = LoggerFactory.getLogger(EntityMetadata.class);
    private Class<E> entityClass;
    private String tableName;
    private String entityName;
    private Map<String, FieldColumn> fieldByName = new HashMap<String, FieldColumn>();
    private Map<String, FieldColumn> fieldByColumn = new HashMap<String, FieldColumn>();
    private List<FieldColumn> keyFields = new ArrayList<FieldColumn>();
    private FieldColumn createTimestampField;
    private FieldColumn updateTimestampField;
    private FieldColumn deletedField;
    private FieldColumn regionField;
    private List<UniqueConstraintCheck> uniquenessChecks = new ArrayList<UniqueConstraintCheck>();
    private Cache cacheSettings;

    public EntityMetadata(Class<E> entityClass) {
        this.entityClass = entityClass;
        Table table = entityClass.getAnnotation(Table.class);
        this.tableName = table != null ? table.name() : entityClass.getSimpleName();
        ExchangeEntity exchangeEntity = entityClass.getAnnotation(ExchangeEntity.class);
        this.entityName = exchangeEntity != null ? exchangeEntity.value() : null;
        for (Field field : entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(EntityField.class)) continue;
            FieldColumn fieldColumn = new FieldColumn(field);
            this.fieldByName.put(fieldColumn.getFieldName(), fieldColumn);
            this.fieldByColumn.put(fieldColumn.getColumnName(), fieldColumn);
            if (field.isAnnotationPresent(Id.class)) {
                this.keyFields.add(fieldColumn);
                continue;
            }
            if (field.isAnnotationPresent(CreateTimestamp.class)) {
                this.createTimestampField = fieldColumn;
                continue;
            }
            if (field.isAnnotationPresent(UpdateTimestamp.class)) {
                this.updateTimestampField = fieldColumn;
                continue;
            }
            if (field.isAnnotationPresent(Deleted.class)) {
                this.deletedField = fieldColumn;
                continue;
            }
            if (!field.isAnnotationPresent(RegionField.class)) continue;
            this.regionField = fieldColumn;
        }
        if (table != null) {
            for (Field field : table.uniqueConstraints()) {
                ArrayList<FieldColumn> uniqueColumns = new ArrayList<FieldColumn>();
                for (String columnName : field.columnNames()) {
                    uniqueColumns.add(this.getFieldByColumn(columnName));
                }
                if (uniqueColumns.isEmpty()) continue;
                this.uniquenessChecks.add(new UniqueConstraintCheck(this.tableName, uniqueColumns.toArray(new FieldColumn[0])));
            }
        }
    }

    public E createEntity() throws ValidationException {
        try {
            return this.entityClass.newInstance();
        }
        catch (InstantiationException ex) {
            logger.error(this.entityClass.getCanonicalName(), (Throwable)ex);
            throw new ValidationException(this.getEntityClassName(), ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            logger.error(this.entityClass.getCanonicalName(), (Throwable)ex);
            throw new ValidationException(this.getEntityClassName(), ex.getMessage());
        }
    }

    public void validate(Object entity) throws ValidationException {
        ValidationException ex = new ValidationException(this.getEntityClassName());
        ex.setSourceEntity(this);
        if (!this.getKeyFields().isEmpty()) {
            FieldColumn fieldColumn = this.getKeyFields().get(0);
            try {
                Object keyValue = fieldColumn.getValue(entity);
                FieldColumnValue fieldColumnValue = new FieldColumnValue(fieldColumn);
                ex.setEntityId(fieldColumnValue.getColumnTextValue(keyValue));
            }
            catch (Throwable e) {
                logger.error(fieldColumn.getFieldName(), (Throwable)ex);
            }
        }
        for (ValidationCheck check : this.getValidationChecks()) {
            try {
                check.validate(entity);
            }
            catch (ValidationException vex) {
                ex.addCause(vex);
            }
        }
        for (Method validateMethod : this.getAnnotatedMethods(Validate.class)) {
            try {
                validateMethod.invoke(entity, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof ValidationException) {
                    ValidationException vex = (ValidationException)e.getCause();
                    vex.setSourceColumn(this.getFieldByName(vex.getSource()));
                    ex.addCause(vex);
                    continue;
                }
                logger.error(validateMethod.getName(), (Throwable)e);
            }
            catch (Throwable e) {
                logger.error(validateMethod.getName(), e);
            }
        }
        if (!ex.getCauses().isEmpty()) {
            throw ex;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public FieldColumn getFieldByName(String fieldName) {
        return this.fieldByName.get(fieldName);
    }

    public FieldColumn getFieldByColumn(String columnName) {
        return this.fieldByColumn.get(columnName.toUpperCase());
    }

    public List<FieldColumn> getAllFields() {
        return Collections.unmodifiableList(new ArrayList<FieldColumn>(this.fieldByName.values()));
    }

    public List<FieldColumn> getKeyFields() {
        return Collections.unmodifiableList(this.keyFields);
    }

    public Map<String, FieldColumn> getFieldMap() {
        return Collections.unmodifiableMap(this.fieldByName);
    }

    public FieldColumn getCreateTimestampField() {
        return this.createTimestampField;
    }

    public FieldColumn getUpdateTimestampField() {
        return this.updateTimestampField;
    }

    public FieldColumn getDeletedField() {
        return this.deletedField;
    }

    public FieldColumn getRegionField() {
        return this.regionField;
    }

    List<ValidationCheck> getValidationChecks() {
        boolean strict = System.getProperty(VALIDATION_MAGIC) == null;
        ArrayList<ValidationCheck> validationChecks = new ArrayList<ValidationCheck>();
        for (FieldColumn fieldColumn : this.getAllFields()) {
            if (!strict && fieldColumn.isAnnotated(SkipValidation.class)) continue;
            validationChecks.addAll(fieldColumn.getValidationChecks());
        }
        return validationChecks;
    }

    public List<UniqueConstraintCheck> getUniquenessChecks() {
        return this.uniquenessChecks;
    }

    public Cache getCacheSettings() {
        return this.cacheSettings;
    }

    public String getEntityClassName() {
        return this.entityClass.getSimpleName();
    }

    public <T extends Annotation> List<FieldColumn> getAnnotatedFields(Class<T> annotationClass) {
        ArrayList<FieldColumn> annotatedFields = new ArrayList<FieldColumn>();
        for (Field field : this.entityClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(this.fieldByName.get(field.getName()));
        }
        return annotatedFields;
    }

    public <T extends Annotation> List<Method> getAnnotatedMethods(Class<T> annotationClass) {
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Method method : this.entityClass.getMethods()) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.entityClass.getAnnotation(annotationClass);
    }

    public Object invokeMethod(E entity, String methodName, Object ... params) {
        try {
            ArrayList paramTypes = new ArrayList();
            for (Object param : params) {
                paramTypes.add(param.getClass());
            }
            Class[] typesArray = new Class[paramTypes.size()];
            paramTypes.toArray(typesArray);
            Method method = this.entityClass.getMethod(methodName, typesArray);
            return this.invokeMethod(entity, method, params);
        }
        catch (IllegalArgumentException ex) {
            logger.error(methodName, (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            logger.error(methodName, (Throwable)ex);
        }
        catch (SecurityException ex) {
            logger.error(methodName, (Throwable)ex);
        }
        return null;
    }

    public Object invokeMethod(E entity, Method method, Object ... params) {
        try {
            return method.invoke(entity, params);
        }
        catch (IllegalAccessException ex) {
            logger.error(method.getName(), (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            logger.error(method.getName(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            logger.error(method.getName(), (Throwable)ex);
        }
        catch (SecurityException ex) {
            logger.error(method.getName(), (Throwable)ex);
        }
        return null;
    }
}

