/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class CharactersExtractHelper {
    public static String getCharacter(int value, int position) {
        if (position < 0) {
            return "";
        }
        return CharactersExtractHelper.getCharacter(String.format("%0" + (position + 1) + "d", value), position);
    }

    public static String getCharacter(Date value, int position, DateFormat format) {
        if (value == null || position < 0) {
            return "";
        }
        String dateString = format.format(value);
        return CharactersExtractHelper.getCharacter(dateString, position);
    }

    public static String getDateHoursCharacter(Date value, int position) {
        if (value == null || position < 0) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("HH");
        return CharactersExtractHelper.getCharacter(value, position, format);
    }

    public static String getDateMinutesCharacter(Date value, int position) {
        if (value == null || position < 0) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("mm");
        return CharactersExtractHelper.getCharacter(value, position, format);
    }

    public static String getCharacter(String value, int position) {
        if (position < 0 || StringUtils.isEmpty((CharSequence)value) || value.length() <= position) {
            return "";
        }
        int index = value.length() - position - 1;
        return value.substring(index, index + 1);
    }
}

