/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.model;

import java.io.ByteArrayInputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.tssoft.kege.dao.TaskMarkupMapper;
import ru.tssoft.kege.model.ValidatableTaskMarkup;
import ru.tssoft.kege.model.ValidationRule;
import ru.tssoft.kege.xml.XmlDomHelper;

public class ValidatableTaskMarkupMapper
extends TaskMarkupMapper {
    private static final Logger logger = LoggerFactory.getLogger(ValidatableTaskMarkupMapper.class);

    public ValidatableTaskMarkupMapper(HttpSession session) {
        super(session);
    }

    @Override
    public ValidatableTaskMarkup toEntity(ResultSet resultSet) throws SQLException {
        try {
            ValidatableTaskMarkup taskMarkup = new ValidatableTaskMarkup();
            super.toEntity(resultSet, taskMarkup);
            taskMarkup.setLangId(this.getInteger(resultSet, "p_lang_id"));
            taskMarkup.setLangName(this.getString(resultSet, "p_lang_name"));
            taskMarkup.setFileNameExt(this.getString(resultSet, "file_name_ext"));
            taskMarkup.setValidationRule(this.getValidationRule(this.xmlText));
            return taskMarkup;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            throw new SQLException(ex);
        }
    }

    private ValidationRule getValidationRule(byte[] taskXml) {
        ValidationRule validationRule = new ValidationRule();
        XmlDomHelper domHelper = new XmlDomHelper(new ByteArrayInputStream(taskXml));
        NodeList nodeValidations = domHelper.getNodeList("/Item/Validations/Validation");
        if (nodeValidations == null) {
            return validationRule;
        }
        for (int i = 0; i < nodeValidations.getLength(); ++i) {
            Node minLengthAhttribute;
            Node validationNode = nodeValidations.item(i);
            NamedNodeMap validationAttributes = validationNode.getAttributes();
            Node typeAttribute = validationAttributes.getNamedItem("Type");
            if (typeAttribute.getTextContent().equals("integer")) {
                Node minValueAhttribute;
                validationRule.setIsInteger(Boolean.TRUE);
                Node maxValueAhttribute = validationAttributes.getNamedItem("max");
                if (maxValueAhttribute != null) {
                    validationRule.setMaxValue(Integer.parseInt(maxValueAhttribute.getTextContent()));
                }
                if ((minValueAhttribute = validationAttributes.getNamedItem("min")) == null) continue;
                validationRule.setMinValue(Integer.parseInt(minValueAhttribute.getTextContent()));
                continue;
            }
            if (typeAttribute.getTextContent().equals("allowed-chars")) {
                Node charsAttribute = validationAttributes.getNamedItem("chars");
                validationRule.setAllowedChars(charsAttribute.getTextContent());
                continue;
            }
            if (!typeAttribute.getTextContent().equals("length")) continue;
            Node maxLengthAhttribute = validationAttributes.getNamedItem("max");
            if (maxLengthAhttribute != null) {
                validationRule.setMaxLength(Integer.parseInt(maxLengthAhttribute.getTextContent()));
            }
            if ((minLengthAhttribute = validationAttributes.getNamedItem("min")) == null) continue;
            validationRule.setMinLength(Integer.parseInt(minLengthAhttribute.getTextContent()));
        }
        return validationRule;
    }
}

