/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.model.examstep;

import ru.tssoft.kege.model.examstep.ExamStepAction;
import ru.tssoft.kege.model.examstep.ExamStepState;
import ru.tssoft.kege.model.examstep.ExamStepType;
import ru.tssoft.kege.model.examstep.ExamStepsHelper;

public class ExamStep {
    private ExamStepType stepType;
    private String name;
    private ExamStepState state;
    private ExamStepAction action;
    private int currentStep;
    private int stepsCount;

    public ExamStep(ExamStepType stepType, String name) {
        this.stepType = stepType;
        this.name = name;
    }

    public String getStateString() {
        return ExamStepsHelper.getExamStepStateName(this.state, this.currentStep, this.stepsCount);
    }

    public String getActionString() {
        return ExamStepsHelper.getExamStepActionName(this.action);
    }

    public String getStateClass() {
        return "state-" + this.state.toString().toLowerCase();
    }

    public String getActionClass() {
        return "action-" + this.action.toString().toLowerCase();
    }

    public String getClientActionName() {
        return String.format("execute%sStep();", new Object[]{this.stepType});
    }

    public String getClientActionNotAvailableName() {
        return String.format("execute%sNotAvailableStep();", new Object[]{this.stepType});
    }

    public ExamStepType getStepType() {
        return this.stepType;
    }

    public String getName() {
        return this.name;
    }

    public ExamStepAction getAction() {
        return this.action;
    }

    public void setAction(ExamStepAction action) {
        this.action = action;
    }

    public ExamStepState getState() {
        return this.state;
    }

    public void setState(ExamStepState state) {
        this.state = state;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public int getStepsCount() {
        return this.stepsCount;
    }

    public void setStepsCount(int stepsCount) {
        this.stepsCount = stepsCount;
    }
}

