/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.model.examstep;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.dao.ExportSharedDao;
import ru.tssoft.kege.dao.KimSharedDao;
import ru.tssoft.kege.dao.OrganizatorOnlineWorkstationDao;
import ru.tssoft.kege.dao.ParticipantOnlineWorkstationDao;
import ru.tssoft.kege.dao.ParticipantSharedDao;
import ru.tssoft.kege.dao.SystemSettingsDao;
import ru.tssoft.kege.model.OnlineWorkstations;
import ru.tssoft.kege.model.examstep.ExamStep;
import ru.tssoft.kege.model.examstep.ExamStepAction;
import ru.tssoft.kege.model.examstep.ExamStepState;
import ru.tssoft.kege.model.examstep.ExamStepType;

@Component
public class ExamStepsProvider {
    @Autowired
    private KimSharedDao kimSharedDao;
    @Autowired
    private ParticipantOnlineWorkstationDao participantOnlineWorkstationDao;
    @Autowired
    private OrganizatorOnlineWorkstationDao organizatorOnlineWorkstationDao;
    @Autowired
    private SystemSettingsDao systemSettingsDao;
    @Autowired
    private ExportSharedDao exportSharedDao;
    @Autowired
    private ParticipantSharedDao participantSharedDao;

    public ExamStep[] getExamSteps() {
        return new ExamStep[]{this.getPrepareExamStep(), this.getPrintProtocolStep(), this.getCheckExamStep(), this.getKimStep(), this.getExportResultsStep()};
    }

    private ExamStep getPrepareExamStep() {
        int steps = 0;
        if (Boolean.valueOf(this.systemSettingsDao.getValue("prepare_tech_confirm")).booleanValue()) {
            ++steps;
        }
        if (Boolean.valueOf(this.systemSettingsDao.getValue("prepare_software_confirm")).booleanValue()) {
            ++steps;
        }
        if (Boolean.valueOf(this.systemSettingsDao.getValue("test_kim_print_complete")).booleanValue()) {
            ++steps;
        }
        if (Boolean.valueOf(this.systemSettingsDao.getValue("test_blank_print_complete")).booleanValue()) {
            ++steps;
        }
        int expectedSteps = 4;
        ExamStep examStep = new ExamStep(ExamStepType.PrepareExam, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044e \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430");
        if (steps < 1) {
            examStep.setState(ExamStepState.NotCompleted);
        } else if (steps < 4) {
            examStep.setState(ExamStepState.PartialCompleted);
            examStep.setCurrentStep(steps);
            examStep.setStepsCount(4);
        } else {
            examStep.setState(ExamStepState.Completed);
        }
        examStep.setAction(ExamStepAction.Execute);
        return examStep;
    }

    private ExamStep getPrintProtocolStep() {
        ExamStep examStep = new ExamStep(ExamStepType.PrintProtocol, "\u041f\u0435\u0447\u0430\u0442\u044c \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438 \u0430\u0443\u0434\u0438\u0442\u043e\u0440\u0438\u0438");
        boolean protocolPrinted = StringUtils.isNotEmpty((CharSequence)this.systemSettingsDao.getValue("print_aud_protocol_complete"));
        if (protocolPrinted) {
            examStep.setState(ExamStepState.Completed);
            examStep.setAction(ExamStepAction.Execute);
            return examStep;
        }
        examStep.setState(ExamStepState.NotCompleted);
        ExamStep prepareExamStep = this.getPrepareExamStep();
        if (prepareExamStep == null || prepareExamStep.getState() != ExamStepState.Completed) {
            examStep.setAction(ExamStepAction.NotAvailable);
        } else {
            examStep.setAction(ExamStepAction.Execute);
        }
        return examStep;
    }

    private ExamStep getCheckExamStep() {
        OnlineWorkstations participantWorkstations = new OnlineWorkstations(this.participantOnlineWorkstationDao);
        OnlineWorkstations organizatorWorkstations = new OnlineWorkstations(this.organizatorOnlineWorkstationDao);
        int expected = participantWorkstations.getExpectedWorkstations() + organizatorWorkstations.getExpectedWorkstations();
        int online = participantWorkstations.getOnlineIps().size() + organizatorWorkstations.getOnlineIps().size();
        ExamStep examStep = new ExamStep(ExamStepType.CheckExam, "\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438 \u0430\u0443\u0434\u0438\u0442\u043e\u0440\u0438\u0438 \u043a \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044e \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430");
        if (online < 1) {
            examStep.setState(ExamStepState.NotCompleted);
        } else if (online >= expected) {
            examStep.setState(ExamStepState.Completed);
        } else {
            examStep.setState(ExamStepState.PartialCompleted);
            examStep.setCurrentStep(online);
            examStep.setStepsCount(expected);
        }
        examStep.setAction(ExamStepAction.MoreInfo);
        return examStep;
    }

    private ExamStep getKimStep() {
        ExamStep examStep = new ExamStep(ExamStepType.Kim, "\u0418\u043c\u043f\u043e\u0440\u0442 \u0438 \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0445 \u041a\u0418\u041c");
        if (this.kimSharedDao.isKimExists()) {
            examStep.setState(ExamStepState.Completed);
        } else {
            examStep.setState(ExamStepState.NotCompleted);
        }
        examStep.setAction(ExamStepAction.Execute);
        return examStep;
    }

    public ExamStep getExportResultsStep() {
        ExamStepAction action;
        ExamStepState state;
        ExamStep examStep = new ExamStep(ExamStepType.ExportResults, "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430");
        if (this.exportSharedDao.exportIsDone()) {
            state = ExamStepState.Completed;
            action = ExamStepAction.Execute;
        } else {
            int uncompletedExams = this.participantSharedDao.getUncompletedExams();
            if (uncompletedExams > 0) {
                action = ExamStepAction.NotAvailable;
                state = ExamStepState.NotCompleted;
            } else {
                action = ExamStepAction.Execute;
                state = ExamStepState.NotCompleted;
            }
        }
        examStep.setState(state);
        examStep.setAction(action);
        return examStep;
    }
}

