/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.servlet;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.dao.ParticipantSharedDao;
import ru.tssoft.kege.servlet.DbFilterBase;

public class DbEncryptionFilter
extends DbFilterBase {
    private static final Logger logger = LoggerFactory.getLogger(DbEncryptionFilter.class);
    private static final String REDIRECT_PAGE = "/cipherdb.htm";
    private ParticipantSharedDao participantDao = new ParticipantSharedDao();

    @Override
    public void init(FilterConfig fc) throws ServletException {
        super.init(fc);
        this.participantDao.setDataSource(this.dataSource);
    }

    @Override
    protected boolean doFilterInternal(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!request.getRequestURI().endsWith(REDIRECT_PAGE)) {
            try {
                String surname = this.participantDao.getRandomParticipantSurname();
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
                logger.info(String.format("\u0417\u0430\u043f\u0440\u043e\u0448\u0435\u043d URI '%s'", request.getRequestURI()));
                logger.info("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u0430\u0442\u044c \u0411\u0414, \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442 \u043d\u0430 /cipherdb.htm");
                response.sendRedirect(request.getContextPath() + REDIRECT_PAGE);
                return true;
            }
        }
        return false;
    }
}

