/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import ru.tssoft.kege.servlet.KegeDataSource;

public abstract class DbFilterBase
implements Filter {
    private List<String> ignoredUrlList;
    protected DataSource dataSource;

    public void init(FilterConfig fc) throws ServletException {
        try {
            this.dataSource = KegeDataSource.get();
        }
        catch (NamingException ex) {
            throw new ServletException((Throwable)ex);
        }
        String ignoredUrls = fc.getInitParameter("ignoredUrls");
        if (StringUtils.isNotEmpty((CharSequence)ignoredUrls)) {
            this.ignoredUrlList = Arrays.asList(ignoredUrls.split(","));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url = ((HttpServletRequest)request).getRequestURI();
        boolean isIgnore = url.endsWith("checkbrowser.html");
        if (this.ignoredUrlList != null) {
            Iterator<String> iterator = this.ignoredUrlList.iterator();
            while (!isIgnore && iterator.hasNext()) {
                String ignoredUrl = iterator.next();
                isIgnore = url.startsWith(ignoredUrl);
            }
        }
        if (!isIgnore && this.doFilterInternal((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    protected abstract boolean doFilterInternal(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
}

