/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.action;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.admin.persistence.DataMapper;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.exchange.ExchangePackage;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.ValidationException;

public abstract class AbstractImportAction {
    protected final DataSource dataSource;
    private ExchangePackage pkg;
    private static final Logger logger = LoggerFactory.getLogger(AbstractImportAction.class);

    public AbstractImportAction(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setPkg(ExchangePackage pkg) {
        this.pkg = pkg;
    }

    public <E> List<E> getEntityList(Class<E> entityClass) throws ExchangeException {
        EntityMetadata<E> dtoMetadata = new EntityMetadata<E>(entityClass);
        try {
            List<E> entityList = this.pkg.getEntityList(entityClass);
            logger.debug("\u0412 \u043f\u0430\u043a\u0435\u0442\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 {} \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c(-\u0442\u0438) '{}'", (Object)entityList.size(), (Object)dtoMetadata.getEntityName());
            return entityList;
        }
        catch (ExchangeException ex) {
            logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' ", dtoMetadata.getEntityName()), (Throwable)ex);
            throw ex;
        }
    }

    public <E> void importEntityList(Class<E> entityClass, List<E> entityList) throws Exception {
        EntityMetadata<E> dtoMetadata = new EntityMetadata<E>(entityClass);
        DataMapper<E> dtoMapper = new DataMapper<E>(dtoMetadata, this.dataSource);
        for (E entity : entityList) {
            try {
                dtoMapper.create(entity);
            }
            catch (SQLException ex) {
                logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' \u0432 \u0411\u0414 ", dtoMetadata.getEntityName()), (Throwable)ex);
                throw ex;
            }
            catch (ValidationException ex) {
                logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' ", dtoMetadata.getEntityName()), (Throwable)ex);
                throw ex;
            }
        }
        logger.debug("\u0412\u0441\u0435 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '{}' \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b", (Object)dtoMetadata.getEntityName());
    }

    public <E> List<E> importEntityList(Class<E> entityClass) throws Exception {
        EntityMetadata<E> dtoMetadata = new EntityMetadata<E>(entityClass);
        String entityName = dtoMetadata.getEntityName();
        try {
            List<E> entityList = this.pkg.getEntityList(entityClass);
            logger.debug("\u0412 \u043f\u0430\u043a\u0435\u0442\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 {} \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c(-\u0442\u0438) '{}'", (Object)entityList.size(), (Object)entityName);
            this.persistEntityList(entityClass, entityList);
            logger.debug("\u0412\u0441\u0435 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '{}' \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b", (Object)entityName);
            return entityList;
        }
        catch (ExchangeException ex) {
            logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' ", entityName), (Throwable)ex);
            throw ex;
        }
    }

    protected <E> void persistEntityList(Class<E> entityClass, List<E> entityList) throws Exception {
        EntityMetadata<E> dtoMetadata = new EntityMetadata<E>(entityClass);
        DataMapper<E> dtoMapper = new DataMapper<E>(dtoMetadata, this.dataSource);
        String entityName = dtoMetadata.getEntityName();
        try {
            for (E entity : entityList) {
                dtoMapper.create(entity);
            }
        }
        catch (SQLException ex) {
            logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' \u0432 \u0411\u0414 ", entityName), (Throwable)ex);
            throw ex;
        }
        catch (ValidationException ex) {
            logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' ", entityName), (Throwable)ex);
            throw ex;
        }
    }
}

