/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.activities;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.activities.KegeUser;
import ru.tssoft.kege.activities.KegeUserAction;
import ru.tssoft.kege.activities.KnownUserNameProvider;
import ru.tssoft.kege.activities.UserNameProvider;
import ru.tssoft.kege.dao.ActivityLogDao;
import ru.tssoft.kege.model.ParticipantExamStatus;

@Component
public class ActivityLogger {
    private static final Logger logger = LoggerFactory.getLogger(ActivityLogger.class);
    private static final int UPDATE_INTERNET_MINUTES = 15;
    @Autowired(required=true)
    private HttpServletRequest request;
    @Autowired
    private ActivityLogDao activityLogDao;

    public ActivityLogger() {
    }

    public ActivityLogger(HttpServletRequest request, ActivityLogDao activityLogDao) {
        this.request = request;
        this.activityLogDao = activityLogDao;
    }

    public void registerAction(KegeUser user, KegeUserAction action, String actionInfo, UserNameProvider userNameProvider) {
        String workstationId = this.getWorkstationId();
        String userName = userNameProvider.getUserName();
        logger.info(String.format("user: [%s]; action: [%s]; userFio: [%s]; workstationId: [%s]; actionInfo: [%s].", new Object[]{user, action, userName, workstationId, actionInfo}));
        this.activityLogDao.createUserAction(user.name(), userName, action.name(), workstationId, actionInfo);
    }

    public void registerInternetAvailableAction() {
        String workstationId = this.getWorkstationId();
        ActivityLogDao.WorkstationIpInfo info = this.activityLogDao.geWorkstationIpInfo(workstationId);
        if (!ParticipantExamStatus.Started.equals((Object)info.getExamStatus())) {
            return;
        }
        int timeLeft = this.activityLogDao.getLastInternetAvailableMinutes(workstationId);
        if (timeLeft >= 15) {
            logger.debug("#registerInternetAvailableAction(): workstationId=[{}], timeLeft=[{}]", (Object)workstationId, (Object)timeLeft);
            this.registerAction(KegeUser.Participant, KegeUserAction.InternetAvailable, null, new KnownUserNameProvider(info.getFio()));
        }
    }

    private String getWorkstationId() {
        InetAddress localhost;
        if (this.request != null) {
            return this.request.getRemoteAddr();
        }
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
        return localhost.getHostAddress();
    }
}

