/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.admin.persistence;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.admin.persistence.GuidGenerator;
import ru.tssoft.kege.admin.persistence.IdGenerator;
import ru.tssoft.kege.admin.persistence.IncrementalGenerator;
import ru.tssoft.kege.admin.persistence.NamedParameterStatement;
import ru.tssoft.kege.admin.persistence.QueryBuilder;
import ru.tssoft.kege.admin.persistence.QueryCache;
import ru.tssoft.kege.metadata.Cache;
import ru.tssoft.kege.metadata.CachedQuery;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.FieldColumn;
import ru.tssoft.kege.metadata.FieldColumnValue;
import ru.tssoft.kege.metadata.PrivateInfo;
import ru.tssoft.kege.metadata.UniqueConstraintCheck;
import ru.tssoft.kege.metadata.UnsupportedTypeConversion;
import ru.tssoft.kege.metadata.ValidationException;

public class DataMapper<E> {
    private static final Logger logger = LoggerFactory.getLogger(DataMapper.class);
    private DataSource dataSource;
    private EntityMetadata<E> entityMetadata;
    private List<String> cachedQueries;

    public DataMapper(EntityMetadata<E> entityMetadata, DataSource dataSource) {
        assert (entityMetadata != null && dataSource != null);
        this.entityMetadata = entityMetadata;
        this.dataSource = dataSource;
        this.cachedQueries = new ArrayList<String>();
        Cache cacheSettings = entityMetadata.getCacheSettings();
        if (cacheSettings != null) {
            for (CachedQuery cachedQuery : cacheSettings.cachedQueries()) {
                this.cachedQueries.add(cachedQuery.value());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(E entity) throws SQLException, ValidationException {
        for (FieldColumn keyField : this.entityMetadata.getKeyFields()) {
            if (keyField.getValue(entity) != null || !keyField.isGenerated()) continue;
            GeneratedValue genValue = keyField.getGeneratedValue();
            IdGenerator generator = null;
            if (genValue.strategy().equals((Object)GenerationType.IDENTITY)) {
                generator = new GuidGenerator();
            } else if (genValue.strategy().equals((Object)GenerationType.SEQUENCE)) {
                generator = new IncrementalGenerator();
            } else {
                throw new IllegalArgumentException("Unsupported generation strategy: " + genValue.strategy());
            }
            String newId = generator.generate(this.dataSource, this.entityMetadata.getTableName(), keyField.getColumnName());
            try {
                keyField.setValue(entity, new FieldColumnValue(keyField).getFieldValue(newId));
            }
            catch (UnsupportedTypeConversion ex) {
                throw new ValidationException(this.entityMetadata.getEntityClassName(), ex.getMessage());
            }
        }
        if (this.entityMetadata.getCreateTimestampField() != null) {
            FieldColumn createTimestampField = this.entityMetadata.getCreateTimestampField();
            try {
                createTimestampField.setValue(entity, new FieldColumnValue(createTimestampField).getFieldValue(new Date()));
            }
            catch (UnsupportedTypeConversion ex) {
                logger.debug(createTimestampField.getFieldName(), (Throwable)ex);
            }
        }
        if (this.entityMetadata.getUpdateTimestampField() != null) {
            FieldColumn updateTimestampField = this.entityMetadata.getUpdateTimestampField();
            try {
                updateTimestampField.setValue(entity, new FieldColumnValue(updateTimestampField).getFieldValue(new Date()));
            }
            catch (UnsupportedTypeConversion ex) {
                logger.debug(updateTimestampField.getFieldName(), (Throwable)ex);
            }
        }
        this.validate(entity);
        String queryName = String.format("%s.create", this.entityMetadata.getEntityClassName());
        String query = QueryCache.getInstance().getQuery(queryName);
        if (query == null) {
            query = new QueryBuilder().insert(this.entityMetadata.getFieldMap(), this.entityMetadata.getTableName()).toString();
            QueryCache.getInstance().addQuery(queryName, query);
        }
        logger.debug("\n{}", (Object)query);
        Connection connection = this.dataSource.getConnection();
        try {
            NamedParameterStatement stmt = new NamedParameterStatement(connection, query);
            this.assignParameters(entity, stmt);
            stmt.executeUpdate();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E read(Object id) throws SQLException, ValidationException {
        String queryName = String.format("%s.select_id", this.entityMetadata.getEntityClassName());
        String query = QueryCache.getInstance().getQuery(queryName);
        if (query == null) {
            HashMap<String, FieldColumn> keyMap = new HashMap<String, FieldColumn>();
            for (FieldColumn keyField : this.entityMetadata.getKeyFields()) {
                keyMap.put(keyField.getFieldName(), keyField);
            }
            query = new QueryBuilder().select(this.entityMetadata.getAllFields(), this.entityMetadata.getTableName()).where(keyMap).toString();
            QueryCache.getInstance().addQuery(queryName, query);
        }
        logger.debug("\n{}", (Object)query);
        E entity = null;
        Connection connection = this.dataSource.getConnection();
        try {
            NamedParameterStatement stmt = new NamedParameterStatement(connection, query);
            for (FieldColumn keyField : this.entityMetadata.getKeyFields()) {
                try {
                    stmt.setObject(keyField.getFieldName(), new FieldColumnValue(keyField).getColumnValue(id));
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.error(keyField.getFieldName(), (Throwable)ex);
                    throw new SQLException(ex);
                }
            }
            ResultSet result = stmt.executeQuery();
            if (result.next()) {
                entity = this.createEntity(result);
            }
        }
        finally {
            connection.close();
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> read() throws SQLException, ValidationException {
        String queryName = String.format("%s.select", this.entityMetadata.getEntityClassName());
        String query = QueryCache.getInstance().getQuery(queryName);
        if (query == null) {
            query = new QueryBuilder().select(this.entityMetadata.getAllFields(), this.entityMetadata.getTableName()).toString();
            QueryCache.getInstance().addQuery(queryName, query);
        }
        logger.debug("\n{}", (Object)query);
        ArrayList<E> entities = new ArrayList<E>();
        Connection connection = this.dataSource.getConnection();
        try {
            PreparedStatement stmt = connection.prepareStatement(query);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                E entity = this.createEntity(result);
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        finally {
            connection.close();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(E entity) throws SQLException, ValidationException {
        if (this.entityMetadata.getUpdateTimestampField() != null) {
            FieldColumn updateTimestampField = this.entityMetadata.getUpdateTimestampField();
            try {
                updateTimestampField.setValue(entity, new FieldColumnValue(updateTimestampField).getFieldValue(new Date()));
            }
            catch (UnsupportedTypeConversion ex) {
                logger.debug(updateTimestampField.getFieldName(), (Throwable)ex);
            }
        }
        this.validate(entity);
        String queryName = String.format("%s.update", this.entityMetadata.getEntityClassName());
        String query = QueryCache.getInstance().getQuery(queryName);
        if (query == null) {
            HashMap<String, FieldColumn> keyMap = new HashMap<String, FieldColumn>();
            for (FieldColumn keyField : this.entityMetadata.getKeyFields()) {
                keyMap.put(keyField.getFieldName(), keyField);
            }
            query = new QueryBuilder().update(this.entityMetadata.getFieldMap(), this.entityMetadata.getTableName()).where(keyMap).toString();
            QueryCache.getInstance().addQuery(queryName, query);
        }
        logger.debug("\n{}", (Object)query);
        Connection connection = this.dataSource.getConnection();
        try {
            NamedParameterStatement stmt = new NamedParameterStatement(connection, query);
            this.assignParameters(entity, stmt);
            stmt.executeUpdate();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(E entity) throws SQLException, ValidationException {
        String queryName = String.format("%s.delete", this.entityMetadata.getEntityClassName());
        String query = QueryCache.getInstance().getQuery(queryName);
        if (query == null) {
            HashMap<String, FieldColumn> keyMap = new HashMap<String, FieldColumn>();
            for (FieldColumn keyField : this.entityMetadata.getKeyFields()) {
                keyMap.put(keyField.getFieldName(), keyField);
            }
            query = new QueryBuilder().delete(this.entityMetadata.getTableName()).where(keyMap).toString();
            QueryCache.getInstance().addQuery(queryName, query);
        }
        logger.debug("\n{}", (Object)query);
        Connection connection = this.dataSource.getConnection();
        try {
            NamedParameterStatement stmt = new NamedParameterStatement(connection, query);
            for (FieldColumn keyField : this.entityMetadata.getKeyFields()) {
                try {
                    FieldColumnValue columnValue = new FieldColumnValue(keyField);
                    stmt.setObject(keyField.getFieldName(), columnValue.getColumnValue(keyField.getValue(entity)));
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.error(keyField.getFieldName(), (Throwable)ex);
                    throw new ValidationException(this.entityMetadata.getEntityClassName(), ex.getMessage());
                }
            }
            stmt.executeUpdate();
        }
        finally {
            connection.close();
        }
    }

    public boolean exists(E entity) throws SQLException, ValidationException {
        if (this.entityMetadata.getKeyFields().isEmpty()) {
            return false;
        }
        FieldColumn keyField = this.entityMetadata.getKeyFields().get(0);
        Object value = keyField.getValue(entity);
        if (value == null) {
            return false;
        }
        return this.read(value) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> find(String queryName, Map<String, Object> criteria) throws SQLException, ValidationException {
        QueryCache queryCache = QueryCache.getInstance();
        if (this.cachedQueries.contains(queryName) && queryCache.getQueryResult(queryName) != null) {
            return (List)queryCache.getQueryResult(queryName);
        }
        String query = queryCache.getQuery(queryName);
        if (query == null) {
            HashMap<String, FieldColumn> keyMap = new HashMap<String, FieldColumn>();
            for (String paramName : criteria.keySet()) {
                FieldColumn fieldColumn = this.entityMetadata.getFieldByName(paramName);
                keyMap.put(paramName, fieldColumn);
            }
            query = new QueryBuilder().select(this.entityMetadata.getAllFields(), this.entityMetadata.getTableName()).where(keyMap).toString();
            queryCache.addQuery(queryName, query);
        }
        logger.debug("\n{}", (Object)query);
        ArrayList<E> entities = new ArrayList<E>();
        Connection connection = this.dataSource.getConnection();
        try {
            NamedParameterStatement stmt = new NamedParameterStatement(connection, query);
            for (String fieldName : criteria.keySet()) {
                FieldColumn fieldColumn = this.entityMetadata.getFieldByName(fieldName);
                try {
                    Object columnValue = new FieldColumnValue(fieldColumn).getColumnValue(criteria.get(fieldName));
                    stmt.setObjectOrNull(fieldName, columnValue, fieldColumn.getColumnType());
                }
                catch (UnsupportedTypeConversion ex) {
                    logger.error(fieldColumn.getFieldName(), (Object)ex.getMessage());
                    throw new ValidationException(this.entityMetadata.getEntityClassName(), ex.getMessage());
                }
            }
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                entities.add(this.createEntity(result));
            }
        }
        finally {
            connection.close();
        }
        if (this.cachedQueries.contains(queryName)) {
            queryCache.cacheQeuryResult(queryName, entities);
        }
        return entities;
    }

    private E createEntity(ResultSet dataSet) throws SQLException, ValidationException {
        E entity = this.entityMetadata.createEntity();
        for (FieldColumn fieldColumn : this.entityMetadata.getAllFields()) {
            try {
                Object columnValue = dataSet.getObject(fieldColumn.getColumnName());
                fieldColumn.setValue(entity, new FieldColumnValue(fieldColumn).getFieldValue(columnValue));
            }
            catch (UnsupportedTypeConversion ex) {
                logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                throw new ValidationException(this.entityMetadata.getEntityClassName(), ex.getMessage());
            }
            catch (ValidationException ex) {
                logger.debug(fieldColumn.getFieldName(), (Throwable)ex);
                throw new ValidationException(this.entityMetadata.getEntityClassName(), ex.getMessage());
            }
        }
        return entity;
    }

    private void assignParameters(E entity, NamedParameterStatement stmt) throws SQLException, ValidationException {
        for (FieldColumn fieldColumn : this.entityMetadata.getAllFields()) {
            Object value;
            if (!fieldColumn.isPersisted()) continue;
            Class<?> typeClass = fieldColumn.getColumnType();
            try {
                value = new FieldColumnValue(fieldColumn).getColumnValue(fieldColumn.getValue(entity));
            }
            catch (UnsupportedTypeConversion ex) {
                logger.error(fieldColumn.getFieldName(), (Throwable)ex);
                throw new ValidationException(this.entityMetadata.getEntityClassName(), ex.getMessage());
            }
            if (typeClass.equals(Clob.class)) {
                stmt.setClob(fieldColumn.getFieldName(), value);
            } else if (typeClass.equals(Blob.class)) {
                stmt.setBlob(fieldColumn.getFieldName(), value);
            } else {
                stmt.setObjectOrNull(fieldColumn.getFieldName(), value, typeClass);
            }
            if (fieldColumn.isAnnotated(PrivateInfo.class)) continue;
            logger.debug("{} = {}", (Object)fieldColumn.getFieldName(), value);
        }
    }

    public void validate(E entity) throws ValidationException {
        this.entityMetadata.validate(entity);
        ValidationException vex = new ValidationException(this.entityMetadata, entity);
        for (UniqueConstraintCheck check : this.entityMetadata.getUniquenessChecks()) {
            try {
                HashMap<String, Object> checkCriteria = new HashMap<String, Object>();
                for (FieldColumn fieldColumn : check.getColumns()) {
                    checkCriteria.put(fieldColumn.getFieldName(), fieldColumn.getValue(entity));
                }
                List<E> result = this.find(null, checkCriteria);
                if (result == null || result.isEmpty()) continue;
                boolean duplicate = false;
                Iterator<E> iterator = result.iterator();
                while (!duplicate && iterator.hasNext()) {
                    E existingEntity = iterator.next();
                    boolean bl = duplicate = !entity.equals(existingEntity);
                    if (this.entityMetadata.getDeletedField() == null) continue;
                    FieldColumn deletedField = this.entityMetadata.getDeletedField();
                    duplicate = duplicate && !deletedField.isDeleted(existingEntity);
                }
                if (!duplicate) continue;
                for (FieldColumn fieldColumn : check.getColumns()) {
                    ValidationException uniquenessException = new ValidationException(fieldColumn, checkCriteria.get(fieldColumn.getFieldName()), "\u0423\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f");
                    vex.addCause(uniquenessException);
                }
            }
            catch (SQLException ex) {
                vex.addCause(new ValidationException(this.entityMetadata.getEntityClassName(), "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043f\u043e\u043b\u044f \u043d\u0430 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c"));
            }
        }
        vex.setSourceEntity(this.entityMetadata);
        if (!vex.getCauses().isEmpty()) {
            ValidationException root = new ValidationException(this.entityMetadata, entity);
            root.addCause(vex);
            throw root;
        }
    }
}

