/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.admin.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ru.tssoft.kege.metadata.FieldColumn;

public class QueryBuilder {
    private StringBuilder sqlBuilder = new StringBuilder();

    public QueryBuilder select(List<FieldColumn> columns, String tableName) {
        this.sqlBuilder.append("SELECT ");
        this.appendColumns(columns.iterator());
        this.sqlBuilder.append("\n");
        this.sqlBuilder.append("FROM ").append(tableName).append("\n");
        return this;
    }

    public QueryBuilder insert(Map<String, FieldColumn> fieldToParam, String tableName) {
        this.sqlBuilder.append("INSERT INTO ").append(tableName).append(" (");
        this.appendColumns(fieldToParam.values().iterator());
        this.sqlBuilder.append(") \nVALUES (");
        Iterator<String> iterator = fieldToParam.keySet().iterator();
        while (iterator.hasNext()) {
            String fieldName = iterator.next();
            FieldColumn fieldColumn = fieldToParam.get(fieldName);
            if (fieldColumn.isPersisted()) {
                this.sqlBuilder.append(":").append(fieldName);
            }
            if (!iterator.hasNext()) break;
            if (!fieldColumn.isPersisted()) continue;
            this.sqlBuilder.append(", ");
        }
        this.sqlBuilder.append(")\n");
        return this;
    }

    public QueryBuilder update(Map<String, FieldColumn> paramByField, String tableName) {
        this.sqlBuilder.append("UPDATE ").append(tableName).append("\n");
        this.sqlBuilder.append("SET ");
        this.appendParams(paramByField, ", ");
        return this;
    }

    public QueryBuilder delete(String tableName) {
        this.sqlBuilder.append("DELETE FROM ").append(tableName).append("\n");
        return this;
    }

    public QueryBuilder where(Map<String, FieldColumn> paramByField) {
        if (paramByField.isEmpty()) {
            return this;
        }
        this.sqlBuilder.append("WHERE ");
        this.appendParams(paramByField, " AND ");
        return this;
    }

    public QueryBuilder where(List<FieldColumn> fields) {
        HashMap<String, FieldColumn> paramMap = new HashMap<String, FieldColumn>();
        for (FieldColumn fieldColumn : fields) {
            paramMap.put(fieldColumn.getFieldName(), fieldColumn);
        }
        return this.where(paramMap);
    }

    public QueryBuilder orderBy(List<FieldColumn> columns) {
        if (columns.isEmpty()) {
            return this;
        }
        this.sqlBuilder.append("ORDER BY ");
        Iterator<FieldColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            this.sqlBuilder.append(iterator.next().getColumnName());
            if (!iterator.hasNext()) break;
            this.sqlBuilder.append(", ");
        }
        this.sqlBuilder.append("\n");
        return this;
    }

    public QueryBuilder nativeCode(String code) {
        this.sqlBuilder.append(code);
        return this;
    }

    private void appendColumns(Iterator<FieldColumn> iterator) {
        while (iterator.hasNext()) {
            FieldColumn column = iterator.next();
            if (column.isPersisted()) {
                this.sqlBuilder.append(column.getColumnName());
            }
            if (!iterator.hasNext()) break;
            if (!column.isPersisted()) continue;
            this.sqlBuilder.append(", ");
        }
    }

    private void appendParams(Map<String, FieldColumn> params, String separator) {
        if (params.isEmpty()) {
            return;
        }
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String param = iterator.next();
            FieldColumn fieldColumn = params.get(param);
            this.sqlBuilder.append(fieldColumn.getColumnName());
            this.sqlBuilder.append(" = :");
            this.sqlBuilder.append(param);
            if (!iterator.hasNext()) break;
            this.sqlBuilder.append(separator);
        }
        this.sqlBuilder.append("\n");
    }

    public String toString() {
        return this.sqlBuilder.toString();
    }
}

