/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.browsercheck;

import java.util.EnumMap;
import java.util.Map;
import nl.bitwalker.useragentutils.Browser;
import nl.bitwalker.useragentutils.UserAgent;
import nl.bitwalker.useragentutils.Version;

public class BrowserValidator {
    public static final Map<Browser, Integer> VALID_BROWSERS = new EnumMap<Browser, Integer>(Browser.class);

    public boolean isValidBrowser(String userAgentHeader) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)userAgentHeader);
        Browser browser = userAgent.getBrowser().getGroup();
        if (!VALID_BROWSERS.containsKey(browser)) {
            return false;
        }
        Version currentBrowserVersion = userAgent.getBrowserVersion();
        if (currentBrowserVersion == null) {
            return false;
        }
        Integer currentVersion = Integer.valueOf(currentBrowserVersion.getMajorVersion());
        Integer validVersion = VALID_BROWSERS.get(browser);
        return currentVersion >= validVersion;
    }

    public boolean isIe(String userAgentHeader) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)userAgentHeader);
        Browser browser = userAgent.getBrowser().getGroup();
        return browser.equals((Object)Browser.IE);
    }

    static {
        VALID_BROWSERS.put(Browser.IE, new Integer(8));
        VALID_BROWSERS.put(Browser.FIREFOX, new Integer(13));
        VALID_BROWSERS.put(Browser.CHROME, new Integer(19));
        VALID_BROWSERS.put(Browser.OPERA, new Integer(12));
        VALID_BROWSERS.put(Browser.SAFARI, new Integer(5));
    }
}

