/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.activities.KegeUser;
import ru.tssoft.kege.activities.KegeUserAction;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.dao.DaoRowHandler;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.model.ParticipantExamStatus;
import ru.tssoft.kege.model.ParticipantFio;

@Component
public class ActivityLogDao
extends AbstractDao {
    private static final Logger logger = LoggerFactory.getLogger(ActivityLogDao.class);
    private static final int ACTION_INFO_VARCHAR_LENGTH = 240;

    public void createUserAction(final String userType, final String userFio, final String action, final String workstationId, final String actionInfo) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection cnctn) throws SQLException {
                String query = "insert into activity_log      (log_id, user_type, user_fio, action,       workstation_id, action_info, action_time) values (?, ?, ?, ?, ?, ?, current_timestamp)";
                PreparedStatement ps = cnctn.prepareStatement(query);
                ps.setString(1, UUID.randomUUID().toString());
                ps.setString(2, userType);
                ps.setString(3, userFio);
                ps.setString(4, action);
                ps.setString(5, workstationId);
                ps.setString(6, actionInfo == null ? null : (actionInfo.length() <= 240 ? actionInfo : actionInfo.substring(0, 240)));
                return ps;
            }
        });
    }

    public int getLastInternetAvailableMinutes(String workstationId) {
        String queryText = "select     coalesce({fn TIMESTAMPDIFF( SQL_TSI_MINUTE, action_time, current_timestamp) }, 10000) as minutes from     activity_log where     user_type = ?     and action = ?     and workstation_id = ? order by action_time desc fetch first row only ";
        ArrayList minutes = new ArrayList();
        new JdbcTemplate(this.dataSource).query(queryText, new Object[]{KegeUser.Participant.name(), KegeUserAction.InternetAvailable.name(), workstationId}, new DaoRowHandler<Integer>(minutes, new EntityMapper<Integer>(){

            @Override
            public Integer toEntity(ResultSet resultSet) throws SQLException {
                return this.getInteger(resultSet, "minutes");
            }
        }));
        return minutes.size() > 0 ? (Integer)minutes.get(0) : 10000;
    }

    public WorkstationIpInfo geWorkstationIpInfo(String ip) {
        ArrayList infos = new ArrayList();
        new JdbcTemplate(this.dataSource).query("select  exam_status as examStatus,  surname,  name,  second_name from      participant_seating where ip = ? fetch first row only", new Object[]{ip}, new DaoRowHandler<WorkstationIpInfo>(infos, new EntityMapper<WorkstationIpInfo>(){

            @Override
            public WorkstationIpInfo toEntity(ResultSet rs) throws SQLException {
                WorkstationIpInfo ipInfo = new WorkstationIpInfo();
                ipInfo.setExamStatus(ParticipantExamStatus.valueOf(rs.getString("examStatus")));
                try {
                    ipInfo.setFio(ParticipantFio.decrypt(rs.getBytes("surname"), rs.getBytes("name"), rs.getBytes("second_name")));
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                return ipInfo;
            }
        }));
        if (infos.size() > 0) {
            return (WorkstationIpInfo)infos.get(0);
        }
        return new WorkstationIpInfo();
    }

    public class WorkstationIpInfo {
        private ParticipantExamStatus examStatus = ParticipantExamStatus.NotEntered;
        private String fio = "";

        public ParticipantExamStatus getExamStatus() {
            return this.examStatus;
        }

        public void setExamStatus(ParticipantExamStatus examStatus) {
            this.examStatus = examStatus;
        }

        public String getFio() {
            return this.fio;
        }

        public void setFio(String fio) {
            this.fio = fio;
        }
    }
}

