/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;

public abstract class EntityMapper<E> {
    public abstract E toEntity(ResultSet var1) throws SQLException;

    protected UUID getUuid(ResultSet resultSet, String columnName) throws SQLException {
        String result = resultSet.getString(columnName);
        return !resultSet.wasNull() ? UUID.fromString(result) : null;
    }

    protected Date getDate(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getDate(columnName);
    }

    protected Date getDateTime(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getTimestamp(columnName);
    }

    protected Timestamp getTimestamp(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getTimestamp(columnName);
    }

    protected Integer getInteger(ResultSet resultSet, String columnName) throws SQLException {
        Integer result = resultSet.getInt(columnName);
        return !resultSet.wasNull() ? result : null;
    }

    protected Short getShort(ResultSet resultSet, String columnName) throws SQLException {
        Short result = resultSet.getShort(columnName);
        return !resultSet.wasNull() ? result : null;
    }

    protected String getString(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getString(columnName);
    }

    protected boolean getBooleanFromShort(ResultSet resultSet, String columnName) throws SQLException {
        Short result = this.getShort(resultSet, columnName);
        return result == null ? false : result == 1;
    }

    protected byte[] getBlobBytes(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getBytes(columnName);
    }
}

