/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.model.FileStorage;

@Component
public class FileStorageDao
extends AbstractDao {
    public static final String SEATING_FILE = "seating";
    public static final String KIM_FILE = "kim";
    public static final String KIM_KEY_FILE = "key_kim";
    public static final String SESSION_PDFIMAGE_PREFIX = "pdfsession";
    public static final String SESSION_ANSWERC_PREFIX = "answerc";
    public static final String SESSION_AUD_PROTOCOL_FILE = "session_aud_protocol";
    public static final String SESSION_TESTKIM_PDF_PREFIX = "testkimpdfsession";
    public static final String SESSION_TESTKIM_HTML_PREFIX = "testkimhtmlsession";
    public static final String SESSION_TESTBLANK_PDF_PREFIX = "testblankpdfsession";
    public static final String SESSION_TESTBLANK_HTML_PREFIX = "testblankhtmlsession";

    public void storeFile(final String id, final String fileName, final InputStream inputStream) throws Exception {
        boolean isFileExists = this.isFileExists(id);
        if (isFileExists) {
            this.deleteFile(id);
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection cnctn) throws SQLException {
                String query = "insert into filestorage(id, filename, data) values(?, ?, ?)";
                PreparedStatement ps = cnctn.prepareStatement(query);
                ps.setString(1, id);
                ps.setString(2, fileName);
                ps.setBinaryStream(3, inputStream);
                return ps;
            }
        });
    }

    public FileStorage getFileStorage(final String id) {
        if (!this.isFileExists(id)) {
            return null;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        FileStorage fileStorage = (FileStorage)jdbcTemplate.query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection cnctn) throws SQLException {
                String query = "select id, filename, data from filestorage where id = ?";
                PreparedStatement ps = cnctn.prepareStatement(query);
                ps.setString(1, id);
                return ps;
            }
        }, (ResultSetExtractor)new ResultSetExtractor<FileStorage>(){

            public FileStorage extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (!rs.next()) {
                    return null;
                }
                FileStorage fileStorage = new FileStorage();
                fileStorage.setId(rs.getString("id"));
                fileStorage.setFileName(rs.getString("filename"));
                Blob blob = rs.getBlob("data");
                ByteArrayInputStream stream = new ByteArrayInputStream(blob.getBytes(1L, (int)blob.length()));
                fileStorage.setInputStream(stream);
                return fileStorage;
            }
        });
        return fileStorage;
    }

    public boolean isFileExists(String id) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int count = jdbcTemplate.queryForInt("select count(1) from filestorage where id = ?", new Object[]{id});
        return count > 0;
    }

    public void deleteFile(String id) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("delete from filestorage where id = ?", new Object[]{id});
    }
}

