/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.dao.OnlineWorkstationDao;

public abstract class OnlineWorkstationDaoBase
extends AbstractDao
implements OnlineWorkstationDao {
    protected abstract WorkstationType getWorkstationType();

    @Override
    public void setOnline(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int count = jdbcTemplate.queryForInt("select count(*) from online_workstation where ip = ?", new Object[]{ip});
        if (count < 1) {
            jdbcTemplate.update("insert into online_workstation(ip, last_ping, workstation_type) values(?, current_timestamp, ?)", new Object[]{ip, this.getWorkstationType().name()});
        } else {
            jdbcTemplate.update("update online_workstation set last_ping = current_timestamp, workstation_type = ? where ip = ?", new Object[]{this.getWorkstationType().name(), ip});
        }
    }

    @Override
    public Map<String, Boolean> getIpStatuses() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        return (Map)jdbcTemplate.query("select     ip,     case         when {fn TIMESTAMPDIFF( SQL_TSI_SECOND, last_ping, current_timestamp) } <= 10 then true         else false     end from     online_workstation where workstation_type = ? order by ip", new Object[]{this.getWorkstationType().name()}, (ResultSetExtractor)new ResultSetExtractor<Map<String, Boolean>>(){

            public Map<String, Boolean> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                while (rs.next()) {
                    map.put(rs.getString(1), Boolean.valueOf(rs.getString(2)));
                }
                return map;
            }
        });
    }

    protected static enum WorkstationType {
        Participant,
        Organizator;

    }
}

