/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import ru.tssoft.kege.dao.AbstractDao;
import ru.tssoft.kege.dao.DaoRowHandler;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.dao.SoftwareDao;
import ru.tssoft.kege.model.SoftwareType;
import ru.tssoft.kege.protocol.AuditoriumReadyProtocol;
import ru.tssoft.kege.protocol.ProtocolSoftwareRow;

@Component
public class ProtocolDao
extends AbstractDao {
    @Autowired
    private SoftwareDao softwareDao;

    public AuditoriumReadyProtocol getAuditoriumReadyProtocol() {
        ArrayList arpList = new ArrayList();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.query("select      s.region,      s.gov_code,      s.station_code,      a.auditorium_code,      e.subject_code,      SUBSTR(e.subject_name, 1, 3) as subject_name,      e.exam_date as examDate,      a.AUDITORIUM_CODE || ' \u2014 ' || a.AUDITORIUM_NAME  as auditoriumName,      (select surname || ' ' || name || ' ' || COALESCE(second_name, '') from worker_appointment wa where wa.worker_position_id = 1 fetch first 1 row only) as ppeManagerFullName,      (select ui.name from USER_INFO ui where ui.LOGIN = 'admin' fetch first 1 row only) as adminFullName,      e.SUBJECT_NAME as subjectName,      (select count(1) from PARTICIPANT_SEATING ps where ps.AUDITORIUM_ID = a.AUDITORIUM_ID) as placesCount,      (select count(1) from PARTICIPANT_SEATING ps where ps.AUDITORIUM_ID = a.AUDITORIUM_ID) as participantsCount from      sysibm.sysdummy1 d      left join (select * from auditorium a where a.active = 1 fetch first 1 row only) a on 1=1      left join (select * from exam e fetch first 1 row only) e on 1=1      left join station s on a.station_id = s.station_id ", new Object[0], new DaoRowHandler<AuditoriumReadyProtocol>(arpList, new EntityMapper<AuditoriumReadyProtocol>(){

            @Override
            public AuditoriumReadyProtocol toEntity(ResultSet resultSet) throws SQLException {
                AuditoriumReadyProtocol item = new AuditoriumReadyProtocol();
                item.setRegion(this.getInteger(resultSet, "region"));
                item.setMouo(this.getInteger(resultSet, "gov_code"));
                item.setPpe(this.getInteger(resultSet, "station_code"));
                item.setAud(this.getString(resultSet, "auditorium_code"));
                item.setSubjectCode(this.getInteger(resultSet, "subject_code"));
                item.setSubjectName(this.getString(resultSet, "subject_name").toUpperCase());
                item.setExamDate(this.getDate(resultSet, "examDate"));
                item.setAuditoriumName(this.getString(resultSet, "auditoriumName"));
                item.setPpeManagerFullName(this.getString(resultSet, "ppeManagerFullName"));
                item.setAdminFullName(this.getString(resultSet, "adminFullName"));
                item.setSubjectFullName(this.getString(resultSet, "subjectName"));
                item.setExamDate(this.getDate(resultSet, "examDate"));
                item.setPlacesCount(this.getInteger(resultSet, "placesCount"));
                item.setParticipantsCount(this.getInteger(resultSet, "participantsCount"));
                return item;
            }
        }));
        if (!arpList.isEmpty()) {
            return (AuditoriumReadyProtocol)arpList.get(0);
        }
        return null;
    }

    public List<ProtocolSoftwareRow> getProtocolSoftwareList() {
        ArrayList<ProtocolSoftwareRow> softwareRowList = new ArrayList<ProtocolSoftwareRow>();
        this.fillProtocolSoftwareList(softwareRowList, SoftwareType.ProgrammingIde, "\u0441\u0440\u0435\u0434\u044b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        this.fillProtocolSoftwareList(softwareRowList, SoftwareType.TextProcessor, "\u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u044b");
        this.fillProtocolSoftwareList(softwareRowList, SoftwareType.GridProcessor, "\u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u044b \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446");
        softwareRowList.add(new ProtocolSoftwareRow("\u2013 \u0430\u043d\u0442\u0438\u0432\u0438\u0440\u0443\u0441\u043d\u043e\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435."));
        return softwareRowList;
    }

    private void fillProtocolSoftwareList(List<ProtocolSoftwareRow> softwareRowList, SoftwareType softwareType, String prefix) {
        List<String> participantsSoftwareNames = this.softwareDao.getParticipantsSoftwareNames(softwareType);
        if (!participantsSoftwareNames.isEmpty()) {
            softwareRowList.add(new ProtocolSoftwareRow(String.format("\u2013 %s: %s;", prefix, StringUtils.join(participantsSoftwareNames, (String)", "))));
        }
    }
}

