/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.dao;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.tssoft.kege.dao.EntityMapper;
import ru.tssoft.kege.dao.SessionFileStorage;
import ru.tssoft.kege.model.TaskAttachment;
import ru.tssoft.kege.model.TaskMarkup;
import ru.tssoft.kege.security.InternalDecryptCipher;
import ru.tssoft.kege.xml.XmlDomHelper;

public class TaskMarkupMapper
extends EntityMapper<TaskMarkup> {
    private static final Logger logger = LoggerFactory.getLogger(TaskMarkupMapper.class);
    protected String imgBaseUrl = "/file/file/";
    protected HttpSession session;
    protected SessionFileStorage sessionFileStorage;
    protected byte[] xmlText;

    public TaskMarkupMapper(HttpSession session) {
        this.session = session;
        this.sessionFileStorage = new SessionFileStorage(session);
    }

    @Override
    public TaskMarkup toEntity(ResultSet resultSet) throws SQLException {
        try {
            TaskMarkup taskMarkup = new TaskMarkup();
            this.toEntity(resultSet, taskMarkup);
            return taskMarkup;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected void toEntity(ResultSet resultSet, TaskMarkup taskMarkup) throws SQLException {
        taskMarkup.setId(this.getUuid(resultSet, "id"));
        taskMarkup.setLabel(this.getString(resultSet, "label"));
        String part = this.getString(resultSet, "part");
        taskMarkup.setPart(part);
        Short answerIndex = this.getShort(resultSet, "answer_index");
        taskMarkup.setAnswerIndex(answerIndex);
        String answerText = this.getString(resultSet, "answer_text");
        taskMarkup.setAnswerText(answerText);
        taskMarkup.setAnswer(answerText, answerIndex, part);
        taskMarkup.setAnswerLang(this.getShort(resultSet, "answer_lang"));
        taskMarkup.setAnswerEncoding(this.getString(resultSet, "answer_encoding_text"));
        taskMarkup.setAnswerChecksum(this.getString(resultSet, "answer_checksum_text"));
        try {
            InternalDecryptCipher kimCipher = InternalDecryptCipher.getInstance();
            this.xmlText = kimCipher.process(this.getBlobBytes(resultSet, "xml_text"));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new SQLException(ex);
        }
        this.parseTaskMarkup(new ByteArrayInputStream(this.xmlText), taskMarkup);
    }

    protected TaskMarkup parseTaskMarkup(InputStream taskXml) {
        if (taskXml == null) {
            return null;
        }
        TaskMarkup taskMarkup = new TaskMarkup();
        this.parseTaskMarkup(taskXml, taskMarkup);
        return taskMarkup;
    }

    protected void parseTaskMarkup(InputStream taskXml, TaskMarkup taskMarkup) {
        Node node;
        Node item;
        int i;
        if (taskXml == null) {
            return;
        }
        XmlDomHelper domHelper = new XmlDomHelper(taskXml);
        HashMap<String, String> namesMap = new HashMap<String, String>();
        NodeList nodeList = domHelper.getNodeList("/Item/Files/File");
        for (i = 0; i < nodeList.getLength(); ++i) {
            item = nodeList.item(i);
            String fileName = item.getAttributes().getNamedItem("name").getTextContent();
            String fileGuidName = String.format("%1$s.%2$s", UUID.randomUUID(), FilenameUtils.getExtension((String)fileName));
            this.storeFile(fileName, fileGuidName, item.getTextContent(), namesMap);
            taskMarkup.getFileNames().add(fileGuidName);
        }
        nodeList = domHelper.getNodeList("/Item/Attachments/Attachment");
        for (i = 0; i < nodeList.getLength(); ++i) {
            item = nodeList.item(i);
            TaskAttachment attachment = new TaskAttachment();
            Node srcAttr = item.getAttributes().getNamedItem("Src");
            Node nameAttr = item.getAttributes().getNamedItem("Name");
            if (srcAttr == null) continue;
            attachment.setSrc(srcAttr.getTextContent());
            if (nameAttr != null) {
                attachment.setName(nameAttr.getTextContent());
            }
            taskMarkup.getAttachments().add(attachment);
            String attachmentUrl = String.format("#\" onclick=\"downloadAttachment('%s','%s')", taskMarkup.getId(), attachment.getId());
            namesMap.put(attachment.getSrc(), attachmentUrl);
        }
        StrSubstitutor sub = new StrSubstitutor(namesMap);
        nodeList = domHelper.getNodeList("/Item/Hint");
        if (nodeList != null) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node item2 = nodeList.item(i2);
                String hint = sub.replace(item2.getTextContent());
                taskMarkup.getHints().add(hint);
            }
        }
        taskMarkup.setCommon((node = domHelper.getNode("/Item/Common")) == null ? null : sub.replace(node.getTextContent()));
        node = domHelper.getNode("/Item/Stem");
        taskMarkup.setStem(node == null ? null : sub.replace(node.getTextContent()));
        node = domHelper.getNode("/Item/Remainder");
        taskMarkup.setRemainder(node == null ? null : sub.replace(node.getTextContent()));
    }

    protected void storeFile(String fileName, String fileGuidName, String fileContent, Map<String, String> namesMap) {
        namesMap.put(fileName, this.imgBaseUrl + fileGuidName);
        if (this.session != null) {
            this.sessionFileStorage.writeFileToSession(fileGuidName, fileContent);
        }
    }

    public String getImgBaseUrl() {
        return this.imgBaseUrl;
    }

    public void setImgBaseUrl(String imgBaseUrl) {
        this.imgBaseUrl = imgBaseUrl;
    }
}

