/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.exchange;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class IOHelper {
    private static final long FILE_COPY_BUFFER_SIZE = 0x100000L;

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = IOHelper.deleteDirectory(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static File createTempDir(String baseName) {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        for (int counter = 0; counter < 1000; ++counter) {
            File tempDir = new File(baseDir, baseName + "/" + System.currentTimeMillis());
            if (!tempDir.mkdirs()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create temp directory");
    }

    public static void copyFileToDirectory(File srcFile, File destDirectory, boolean overwrite) throws IOException {
        File destFile = new File(destDirectory, srcFile.getName());
        if (destFile.exists() && overwrite) {
            destFile.delete();
        }
        destFile.getParentFile().mkdirs();
        IOHelper.copyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel input = null;
        AbstractInterruptibleChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = ((FileChannel)input).size();
            long count = 0L;
            for (long pos = 0L; pos < size; pos += ((FileChannel)output).transferFrom((ReadableByteChannel)((Object)input), pos, count)) {
                count = size - pos > 0x100000L ? 0x100000L : size - pos;
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (input != null) {
                input.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
    }
}

